# Generated code configuration

Run `dotnet build /t:GenerateCode` to generate code.

``` yaml

azure-arm: true
csharp: true
library-name: RecoveryServicesSiteRecovery
namespace: Azure.ResourceManager.RecoveryServicesSiteRecovery
require: https://github.com/Azure/azure-rest-api-specs/blob/39608b2c1c7b7dc06cb99abb9d733665cfce9a75/specification/recoveryservicessiterecovery/resource-manager/readme.md
#tag: package-2023-08
output-folder: $(this-folder)/Generated
clear-output-folder: true
sample-gen:
  output-folder: $(this-folder)/../samples/Generated
  clear-output-folder: true
  skipped-operations:
    # The discriminator value is incorrect
    - ReplicationFabrics_Create
    - ReplicationProtectionContainers_Create
    - ReplicationProtectedItems_Delete
    - ReplicationProtectionContainerMappings_Create
    # Missing requried parameter
    - ReplicationJobs_Export
skip-csproj: true
modelerfour:
  flatten-payloads: false
use-model-reader-writer: true
use-write-core: true

#mgmt-debug:
#  show-serialized-names: true

rename-mapping:
  Alert: SiteRecoveryAlert
  AlertProperties: SiteRecoveryAlertProperties
  AlertCollection: SiteRecoveryAlertListResult
  ApplianceCollection: SiteRecoveryApplianceListResult
  ApplianceSpecificDetails: SiteRecoveryApplianceSpecificDetails
  ASRTask: AsrTask
  A2ACrossClusterMigrationReplicationDetails.primaryFabricLocation: -|azure-location
  A2AVmManagedDiskInputDetails: A2AVmManagedDiskDetails
  A2AProtectedDiskDetails.resyncRequired: IsResyncRequired
  A2AProtectedManagedDiskDetails.recoveryTargetDiskId: -|arm-id
  A2AProtectedManagedDiskDetails.recoveryReplicaDiskId: -|arm-id
  A2AProtectedManagedDiskDetails.recoveryOrignalTargetDiskId: -|arm-id
  A2AProtectedManagedDiskDetails.resyncRequired: IsResyncRequired
  A2AProtectionIntentDiskInputDetails: A2AProtectionIntentDiskDetails
  A2AProtectionIntentManagedDiskInputDetails: A2AProtectionIntentManagedDiskDetails
  A2AVmDiskInputDetails: A2AVmDiskDetails
  AzureToAzureVmSyncedConfigDetails.inputEndpoints: VmEndpoints
  AddDisksInput: SiteRecoveryAddDisksContent
  AddDisksInputProperties: SiteRecoveryAddDisksProperties
  AddDisksProviderSpecificInput: SiteRecoveryAddDisksProviderSpecificContent
  AddVCenterRequestProperties: SiteRecoveryAddVCenterProperties
  AddVCenterRequestProperties.ipAddress: -|ip-address
  AddRecoveryServicesProviderInputProperties: SiteRecoveryAddRecoveryServicesProviderProperties
  AgentAutoUpdateStatus: SiteRecoveryAgentAutoUpdateStatus
  AgentDetails: SiteRecoveryAgentDetails
  AgentDiskDetails: SiteRecoveryAgentDiskDetails
  AgentVersionStatus: SiteRecoveryAgentVersionStatus
  ApplyRecoveryPointInput: SiteRecoveryApplyRecoveryPointContent
  ApplyRecoveryPointInputProperties: SiteRecoveryApplyRecoveryPointProperties
  ApplyRecoveryPointProviderSpecificInput: SiteRecoveryApplyRecoveryPointProviderSpecificContent
  AzureFabricCreationInput: SiteRecoveryFabricProviderCreationContent
  AzureFabricSpecificDetails: SiteRecoveryFabricProviderSpecificDetails
  AzureFabricSpecificDetails.containerIds: -|arm-id
  AzureToAzureCreateNetworkMappingInput: A2ACreateNetworkMappingContent
  AzureToAzureNetworkMappingSettings: A2ANetworkMappingSettings
  AzureToAzureUpdateNetworkMappingInput: A2AUpdateNetworkMappingContent
  AzureToAzureVmSyncedConfigDetails: A2AVmSyncedConfigDetails
  AzureVmDiskDetails: SiteRecoveryVmDiskDetails
  ConfigurationSettings: SiteRecoveryReplicationProviderSettings
  ConfigureAlertRequestProperties: SiteRecoveryConfigureAlertProperties
  CreateNetworkMappingInputProperties: SiteRecoveryCreateReplicationNetworkMappingProperties
  CreateProtectionContainerInputProperties: SiteRecoveryCreateProtectionContainerProperties
  CreateProtectionContainerMappingInputProperties: SiteRecoveryCreateProtectionContainerMappingProperties
  ComputeSizeErrorDetails: SiteRecoveryComputeSizeErrorDetails
  CreatePolicyInputProperties: SiteRecoveryCreatePolicyProperties
  CreateProtectionContainerMappingInputProperties.targetProtectionContainerId: -|arm-id
  CreateProtectionIntentProperties: SiteRecoveryCreateProtectionIntentProperties
  CreateProtectionIntentProviderSpecificDetails: SiteRecoveryCreateProtectionIntentProviderDetail
  CreateRecoveryPlanInputProperties: SiteRecoveryCreateRecoveryPlanProperties
  DataStore: SiteRecoveryDataStore
  DataStore.uuid: -|uuid
  DataSyncStatus: SiteRecoveryDataSyncStatus
  DisableProtectionInputProperties: DisableProtectionProperties
  DiskAccountType: SiteRecoveryDiskAccountType
  DiscoverProtectableItemRequestProperties: DiscoverProtectableItemProperties
  DiskDetails: SiteRecoveryDiskDetails
  DiskEncryptionInfo: SiteRecoveryDiskEncryptionInfo
  DiskEncryptionKeyInfo: SiteRecoveryDiskEncryptionKeyInfo
  DiskReplicationProgressHealth: SiteRecoveryDiskReplicationProgressHealth
  DiskVolumeDetails: SiteRecoveryDiskVolumeDetails
  DraDetails: SiteRecoveryDraDetails
  DraDetails.lastHeartbeatUtc: LastHeartbeatReceivedOn
  EnableMigrationInputProperties: EnableMigrationProperties
  EnableProtectionInputProperties: EnableProtectionProperties
  EncryptionDetails: SiteRecoveryEncryptionDetails
  EthernetAddressType: SiteRecoveryEthernetAddressType
  Event: SiteRecoveryEvent
  EventCollection: SiteRecoveryListResult
  EventProperties: SiteRecoveryEventProperties
  EventProperties.timeOfOccurrence: OccurredOn
  EventProviderSpecificDetails: SiteRecoveryEventProviderSpecificDetails
  EventSpecificDetails: SiteRecoveryEventSpecificDetails
  ExtendedLocation: SiteRecoveryExtendedLocation
  ExtendedLocationType: SiteRecoveryExtendedLocationType
  Fabric: SiteRecoveryFabric
  FabricCollection: SiteRecoveryFabricListResult
  FabricProperties: SiteRecoveryFabricProperties
  FabricCreationInputProperties: FabricCreationProperties
  FailoverProcessServerRequest: FailoverProcessServerContent
  FailoverProcessServerRequestProperties: FailoverProcessServerProperties
  GroupTaskDetails: SiteRecoveryGroupTaskDetails
  HealthError: SiteRecoveryHealthError
  HyperVReplicaAzureDiskInputDetails: HyperVReplicaAzureDiskDetails
  HyperVReplicaAzureEnableProtectionInput.hvHostVmId: HyperVHostVmId
  HyperVReplicaAzureEnableProtectionInput.targetAzureSubnetId: -|arm-id
  HyperVReplicaAzureReprotectInput.hvHostVmId: HyperVHostVmId
  HyperVReplicaAzureReprotectInput.vHDId: VhdId
  HyperVVirtualMachineDetails: HyperVVmDetails
  InMageAzureV2EnableProtectionInput.targetAzureSubnetId: -|arm-id
  InMageAzureV2DiskInputDetails: InMageAzureV2DiskDetails
  InMageAzureV2ProtectedDiskDetails.psDataInMegaBytes: PSDataInMegaBytes
  InMageAzureV2ProtectedDiskDetails.resyncLastDataTransferTimeUTC: ResyncLastDataTransferOn
  InMageAzureV2SwitchProviderDetails.targetVaultId: -|arm-id
  InMageAzureV2SwitchProviderDetails.targetResourceId: -|arm-id
  InMageAzureV2SwitchProviderInput.targetVaultID: -|arm-id
  InMageProtectedDiskDetails.psDataInMB: PSDataInMB
  InMageRcmDiscoveredProtectedVmDetails.createdTimestamp: CreatedOn
  InMageRcmDiscoveredProtectedVmDetails.updatedTimestamp: UpdatedOn
  InMageRcmFabricSpecificDetails.serviceResourceId: -|arm-id
  InMageRcmFailbackDiscoveredProtectedVmDetails.createdTimestamp: CreatedOn
  InMageRcmFailbackDiscoveredProtectedVmDetails.updatedTimestamp: UpdatedOn
  InMageRcmFailbackDiscoveredProtectedVmDetails.lastDiscoveryTimeInUtc: LastDiscoveredOn
  InMageRcmFailbackMobilityAgentDetails.lastHeartbeatUtc: LastHeartbeatReceivedOn
  InMageRcmFailbackProtectedDiskDetails.lastSyncTime: LastSyncedOn
  InMageRcmFailbackReplicationDetails.azureVirtualMachineId: -|arm-id
  InMageRcmFailbackReplicationDetails.targetvCenterId: TargetVCenterId
  InMageRcmFailbackSyncDetails.lastDataTransferTimeUtc: LastDataTransferOn|date-time
  InMageRcmFailbackSyncDetails.startTime: StartOn|date-time
  InMageRcmFailbackSyncDetails.lastRefreshTime: LastRefreshedOn|date-time
  InMageRcmMobilityAgentDetails.lastHeartbeatUtc: LastHeartbeatReceivedOn
  InMageRcmSyncDetails.startTime: StaStartOn|date-time
  InMageRcmSyncDetails.lastRefreshTime: LastRefreshedOn|date-time
  InMageReplicationDetails.retentionWindowStart: RetentionWindowStartOn
  InMageReplicationDetails.retentionWindowEnd: RetentionWindowEndOn
  InMageReplicationDetails.lastHeartbeat: LastHeartbeatReceivedOn
  InnerHealthError: SiteRecoveryInnerHealthError
  InnerHealthError.creationTimeUtc: CreatedOn
  InputEndpoint: SiteRecoveryVmEndpoint
  IPConfigInputDetails: HyperVFailoverIPConfigDetails
  IPConfigInputDetails.recoveryPublicIPAddressId: -|arm-id
  IPConfigInputDetails.tfoPublicIPAddressId: -|arm-id
  IPConfigDetails: HyperVIPConfigDetails
  IPConfigDetails.recoveryPublicIPAddressId: -|arm-id
  IPConfigDetails.tfoPublicIPAddressId: -|arm-id
  Job: SiteRecoveryJob
  JobCollection: SiteRecoveryJobListResult
  JobErrorDetails: SiteRecoveryJobErrorDetails
  JobDetails: SiteRecoveryJobDetails
  JobEntity: SiteRecoveryJobEntity
  JobProperties: SiteRecoveryJobProperties
  JobQueryParameter: SiteRecoveryJobQueryContent
  JobQueryParameter.startTime: StartOn
  JobQueryParameter.endTime: EndOn
  JobStatusEventDetails: SiteRecoveryJobStatusEventDetails
  JobTaskDetails: SiteRecoveryJobTaskDetails
  KeyEncryptionKeyInfo: SiteRecoveryKeyEncryptionKeyInfo
  LicenseType: SiteRecoveryLicenseType
  LogicalNetwork: SiteRecoveryLogicalNetwork
  LogicalNetworkCollection: SiteRecoveryLogicalNetworkListResult
  LogicalNetworkProperties: SiteRecoveryLogicalNetworkProperties
  MarsAgentDetails.lastHeartbeatUtc: LastHeartbeatReceivedOn
  MasterTargetServer.lastHeartbeat: LastHeartbeatReceivedOn
  MigrateInput: SiteRecoveryMigrateContent
  MigrateInputProperties: SiteRecoveryMigrateProperties
  MigrationItem: SiteRecoveryMigrationItem
  MigrationItemCollection: SiteRecoveryMigrationItemListResult
  MigrationItemProperties: SiteRecoveryMigrationItemProperties
  MigrationRecoveryPointCollection: MigrationRecoveryPointListResult
  MigrationState: SiteRecoveryMigrationState
  Network: SiteRecoveryNetwork
  NetworkProperties: SiteRecoveryNetworkProperties
  NetworkCollection: SiteRecoveryNetworkListResult
  NetworkMapping: SiteRecoveryNetworkMapping
  NetworkMappingCollection: SiteRecoveryNetworkMappingListResult
  NetworkMappingProperties: SiteRecoveryNetworkMappingProperties
  OSDetails: SiteRecoveryOSDetails
  OSDiskDetails: SiteRecoveryOSDiskDetails
  OSVersionWrapper: SiteRecoveryOSVersionWrapper
  PauseReplicationInputProperties: PauseReplicationProperties
  PlannedFailoverInputProperties: PlannedFailoverProperties
  Policy: SiteRecoveryPolicy
  PolicyCollection: SiteRecoveryPolicyListResult
  PolicyProperties: SiteRecoveryPolicyProperties
  PresenceStatus: HyperVVmDiskPresenceStatus
  ProcessServer: SiteRecoveryProcessServer
  ProcessServer.lastHeartbeat: LastHeartbeatReceivedOn
  ProcessServerDetails: SiteRecoveryProcessServerDetails
  ProcessServerDetails.lastHeartbeatUtc: LastHeartbeatReceivedOn
  ProtectableItem: SiteRecoveryProtectableItem
  ProtectableItemCollection: SiteRecoveryProtectableItemListResult
  ProtectableItemProperties: SiteRecoveryProtectableItemProperties
  ProtectableItemProperties.replicationProtectedItemId: -|arm-id
  ProtectableItemProperties.recoveryServicesProviderId: -|arm-id
  ProtectionContainer: SiteRecoveryProtectionContainer
  ProtectionContainerCollection: SiteRecoveryProtectionContainerListResult
  ProtectionContainerProperties: SiteRecoveryProtectionContainerProperties
  ProtectionContainerMappingCollection: ProtectionContainerMappingListResult
  ProtectionContainerMappingProperties.targetProtectionContainerId: -|arm-id
  ProtectionHealth: SiteRecoveryProtectionHealth
  ProviderError: SiteRecoveryJobProviderError
  PushInstallerDetails.lastHeartbeatUtc: LastHeartbeatReceivedOn
  RcmProxyDetails.lastHeartbeatUtc: LastHeartbeatReceivedOn
  RecoveryPlan: SiteRecoveryRecoveryPlan
  RecoveryPlanCollection: SiteRecoveryRecoveryPlanListResult
  RecoveryPlanProperties: SiteRecoveryRecoveryPlanProperties
  RecoveryPlanA2AInput: RecoveryPlanA2AContent
  RecoveryPlanAutomationRunbookActionDetails.runbookId: -|arm-id
  RecoveryPlanGroup: SiteRecoveryPlanGroup
  RecoveryPoint: SiteRecoveryPoint
  RecoveryPointCollection: SiteRecoveryPointListResult
  RecoveryPointProperties: SiteRecoveryPointProperties
  RecoveryPointType: SiteRecoveryPointType
  RecoveryServicesProvider: SiteRecoveryServicesProvider
  RecoveryServicesProviderCollection: SiteRecoveryServicesProviderListResult
  RecoveryServicesProviderProperties: SiteRecoveryServicesProviderProperties
  RecoveryServicesProviderProperties.lastHeartBeat: LastHeartbeatReceivedOn
  RecoveryPlanPlannedFailoverInputProperties: RecoveryPlanPlannedFailoverProperties
  RecoveryPlanProtectedItem.id: -|arm-id
  RecoveryPlanTestFailoverCleanupInputProperties: RecoveryPlanTestFailoverCleanupProperties
  RecoveryPlanTestFailoverInputProperties: RecoveryPlanTestFailoverProperties
  RecoveryPlanUnplannedFailoverInputProperties: RecoveryPlanUnplannedFailoverProperties
  RecoveryPlanUnplannedFailoverInputProperties.sourceSiteOperations: SourceSiteOperation
  RemoveProtectionContainerMappingInputProperties: RemoveProtectionContainerMappingProperties
  ReplicationAppliance: SiteRecoveryReplicationAppliance
  ReplicationApplianceProperties: SiteRecoveryReplicationApplianceProperties
  ReplicationEligibilityResultsCollection: ReplicationEligibilityResultListResult
  ReplicationEligibilityResultsErrorInfo: ReplicationEligibilityResultErrorInfo
  ReplicationEligibilityResultsProperties: ReplicationEligibilityResultProperties
  ReplicationProtectedItemCollection: ReplicationProtectedItemListResult
  ReplicationProtectedItemProperties.eventCorrelationId: -|uuid
  ReplicationProtectionIntentCollection: ReplicationProtectionIntentListResult
  ReplicationProtectionIntentProperties.creationTimeUTC: CreatedOn
  ReprotectAgentDetails.lastHeartbeatUtc: LastHeartbeatReceivedOn
  ReprotectAgentDetails.lastDiscoveryInUtc: Last
  ResumeJobParams: ReplicationResumeJobContent
  ResumeJobParamsProperties: ReplicationResumeJobProperties
  ResumeReplicationInputProperties: ResumeReplicationProperties
  ResyncInput: MigrationItemResyncContent
  ResyncInputProperties: MigrationItemResyncProperties
  ResyncState: SiteRecoveryResyncState
  RetentionVolume: SiteRecoveryRetentionVolume
  ReverseReplicationInputProperties: ReverseReplicationProperties
  RunAsAccount: SiteRecoveryRunAsAccount
  ServiceError: SiteRecoveryServiceError
  Severity: SiteRecoveryErrorSeverity
  SqlServerLicenseType: SiteRecoverySqlServerLicenseType
  StorageClassificationCollection: StorageClassificationListResult
  StorageClassificationProperties: StorageClassificationProperties
  StorageClassificationMappingCollection: StorageClassificationMappingListResult
  StorageClassificationMappingProperties.targetStorageClassificationId: -|arm-id
  StorageMappingInputProperties: StorageMappingProperties
  StorageMappingInputProperties.targetStorageClassificationId: -|arm-id
  Subnet: SiteRecoverySubnet
  SupportedOperatingSystems: SiteRecoverySupportedOperatingSystems
  SupportedOSDetails: SiteRecoverySupportedOSDetails
  SupportedOSProperties: SiteRecoverySupportedOSProperties
  SupportedOSProperty: SiteRecoverySupportedOSProperty
  SwitchProtectionInputProperties: SwitchProtectionProperties
  SwitchProtectionJobDetails.newReplicationProtectedItemId: -|arm-id
  SwitchProviderInputProperties: SwitchProviderProperties
  TargetComputeSizeCollection: TargetComputeSizeListResult
  TaskTypeDetails: SiteRecoveryTaskTypeDetails
  TestFailoverCleanupInputProperties: TestFailoverCleanupProperties
  TestFailoverInputProperties: TestFailoverProperties
  TestMigrateCleanupInputProperties: TestMigrateCleanupProperties
  TestMigrateInputProperties: TestMigrateProperties
  UpdateApplianceForReplicationProtectedItemInputProperties: UpdateApplianceForReplicationProtectedItemProperties
  UpdateMigrationItemInputProperties: UpdateMigrationItemProperties
  UpdateNetworkMappingInputProperties: UpdateNetworkMappingProperties
  UpdateReplicationProtectedItemInputProperties: UpdateReplicationProtectedItemProperties
  UpdateVCenterRequestProperties: SiteRecoveryUpdateVCenterProperties
  UnplannedFailoverInputProperties: UnplannedFailoverProperties
  VaultSetting: SiteRecoveryVaultSetting
  VaultSettingCollection: SiteRecoveryVaultSettingListResult
  VaultSettingProperties: SiteRecoveryVaultSettingProperties
  VaultSettingCreationInputProperties: VaultSettingCreationProperties
  VCenter: SiteRecoveryVCenter
  VCenterCollection: SiteRecoveryVCenterListResult
  VCenterProperties: SiteRecoveryVCenterProperties
  VCenterProperties.lastHeartbeat: LastHeartbeatReceivedOn
  VersionDetails: SiteRecoveryVersionDetails
  SecurityType: SiteRecoveryVmSecurityType
  VirtualMachineTaskDetails: SiteRecoveryVmTaskDetails
  VmEncryptionType: SiteRecoveryVmEncryptionType
  VmmDetails: VmmFabricDetails
  VmmVirtualMachineDetails: VmmVmDetails
  VMwareDetails.psTemplateVersion: PSTemplateVersion
  VMwareVirtualMachineDetails: VMwareVmDetails
  VMNicInputDetails.enableAcceleratedNetworkingOnRecovery: IsAcceleratedNetworkingOnRecoveryEnabled
  VMNicInputDetails.enableAcceleratedNetworkingOnTfo: IsAcceleratedNetworkingOnTfoEnabled
  VMNicInputDetails.reuseExistingNic: IsReuseExistingNicAllowed
  VMNicInputDetails.tfoReuseExistingNic: IsTfoReuseExistingNicAllowed
  VMNicDetails.enableAcceleratedNetworkingOnRecovery: IsAcceleratedNetworkingOnRecoveryEnabled
  VMNicDetails.enableAcceleratedNetworkingOnTfo: IsAcceleratedNetworkingOnTfoEnabled
  VMNicDetails.reuseExistingNic: IsReuseExistingNicAllowed
  VMNicDetails.tfoReuseExistingNic: IsTfoReuseExistingNicAllowed
  VMwareCbtEnableMigrationInput.dataMoverRunAsAccountId: -|arm-id
  VMwareCbtEnableMigrationInput.snapshotRunAsAccountId: -|arm-id
  VMwareCbtMigrationDetails.dataMoverRunAsAccountId: -|arm-id
  VMwareCbtMigrationDetails.snapshotRunAsAccountId: -|arm-id
  VMwareV2FabricSpecificDetails.serviceResourceId: -|arm-id

format-by-name-rules:
  'tenantId': 'uuid'
  'ETag': 'etag'
  'location': 'azure-location'
  '*Uri': 'Uri'
  '*Uris': 'Uri'
  '*ResourceGroupId': 'arm-id'
  '*FabricObjectId': 'arm-id'
  '*ArmId': 'arm-id'
  'RecoveryContainerId': 'arm-id'
  '*AvailabilitySetId': 'arm-id'
  '*ProximityPlacementGroupId': 'arm-id'
  '*StorageAccountId': 'arm-id'
  '*VirtualMachineScaleSetId': 'arm-id'
  '*NetworkId': 'arm-id'
  '*CapacityReservationGroupId': 'arm-id'
  '*KeyVaultId': 'arm-id'
  '*FabricLocation': 'azure-location'
  '*DiskEncryptionSetId': 'arm-id'
  'PrimaryLocation': 'azure-location'
  'RecoveryLocation': 'azure-location'
  '*PolicyId': 'arm-id'
  '*RecoveryPointId': 'arm-id'
  '*FabricId': 'arm-id'
  'JobId': 'arm-id'
  'ProtectableItemId': 'arm-id'
  '*IPAddress': 'ip-address'
  '*IPAddresses': 'ip-address'
  'VMwareSiteId': 'arm-id'
  'PhysicalSiteId': 'arm-id'
  'MigrationSolutionId': 'arm-id'
  'VMwareMachineId': 'arm-id'
  '*ProcessServerId': 'uuid'

acronym-mapping:
  CPU: Cpu
  CPUs: Cpus
  Os: OS
  Ip: IP
  Ips: IPs|ips
  ID: Id
  IDs: Ids
  VM: Vm
  VMs: Vms
  Vmos: VmOS
  VMScaleSet: VmScaleSet
  DNS: Dns
  VPN: Vpn
  NAT: Nat
  WAN: Wan
  Ipv4: IPv4|ipv4
  Ipv6: IPv6|ipv6
  Ipsec: IPsec|ipsec
  SSO: Sso
  URI: Uri
  Etag: ETag|etag
  LRS: Lrs
  SSD: Ssd
  Vmware: VMware|vmware
  VCPUs: VCpus
  Vcenter: VCenter
  ExpiryOn: ExpireOn
  ExpiryDate: ExpireOn
  Input: Content

request-path-to-parent:
  /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationJobs/export: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationJobs/{jobName}

directive:
  - remove-operation: Operations_List
  # Because can't rename the purge operation, so have to make this change to avoid compiling error.
  # Issue filed here: https://github.com/Azure/autorest.csharp/issues/2742
  - remove-operation: ReplicationFabrics_Purge
  - remove-operation: ReplicationRecoveryServicesProviders_Purge
  # Why the `client` value can't be processing correctly but only `method`?
  - from: service.json
    where: $.parameters
    transform: >
      $.ResourceGroupName['x-ms-parameter-location'] = 'method';
      $.ResourceName['x-ms-parameter-location'] = 'method';

```
