// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Hyper V VM network input details. </summary>
    public partial class VmNicContentDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VmNicContentDetails"/>. </summary>
        public VmNicContentDetails()
        {
            IPConfigs = new ChangeTrackingList<HyperVFailoverIPConfigDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="VmNicContentDetails"/>. </summary>
        /// <param name="nicId"> The nic Id. </param>
        /// <param name="ipConfigs"> The IP configurations to be used by NIC during test failover and failover. </param>
        /// <param name="selectionType"> Selection type for failover. </param>
        /// <param name="recoveryNetworkSecurityGroupId"> The id of the NSG associated with the NIC. </param>
        /// <param name="isAcceleratedNetworkingOnRecoveryEnabled"> Whether the NIC has accelerated networking enabled. </param>
        /// <param name="tfoNetworkSecurityGroupId"> The NSG to be used by NIC during test failover. </param>
        /// <param name="isAcceleratedNetworkingOnTfoEnabled"> Whether the test NIC has accelerated networking enabled. </param>
        /// <param name="recoveryNicName"> The name of the NIC to be used when creating target NICs. </param>
        /// <param name="recoveryNicResourceGroupName"> The resource group of the NIC to be used when creating target NICs. </param>
        /// <param name="isReuseExistingNicAllowed"> A value indicating whether an existing NIC is allowed to be reused during failover subject to availability. </param>
        /// <param name="tfoNicName"> The name of the NIC to be used when creating target NICs in TFO. </param>
        /// <param name="tfoNicResourceGroupName"> The resource group of the NIC to be used when creating target NICs in TFO. </param>
        /// <param name="isTfoReuseExistingNicAllowed"> A value indicating whether an existing NIC is allowed to be reused during test failover subject to availability. </param>
        /// <param name="targetNicName"> Target NIC name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VmNicContentDetails(string nicId, IList<HyperVFailoverIPConfigDetails> ipConfigs, string selectionType, string recoveryNetworkSecurityGroupId, bool? isAcceleratedNetworkingOnRecoveryEnabled, string tfoNetworkSecurityGroupId, bool? isAcceleratedNetworkingOnTfoEnabled, string recoveryNicName, string recoveryNicResourceGroupName, bool? isReuseExistingNicAllowed, string tfoNicName, string tfoNicResourceGroupName, bool? isTfoReuseExistingNicAllowed, string targetNicName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NicId = nicId;
            IPConfigs = ipConfigs;
            SelectionType = selectionType;
            RecoveryNetworkSecurityGroupId = recoveryNetworkSecurityGroupId;
            IsAcceleratedNetworkingOnRecoveryEnabled = isAcceleratedNetworkingOnRecoveryEnabled;
            TfoNetworkSecurityGroupId = tfoNetworkSecurityGroupId;
            IsAcceleratedNetworkingOnTfoEnabled = isAcceleratedNetworkingOnTfoEnabled;
            RecoveryNicName = recoveryNicName;
            RecoveryNicResourceGroupName = recoveryNicResourceGroupName;
            IsReuseExistingNicAllowed = isReuseExistingNicAllowed;
            TfoNicName = tfoNicName;
            TfoNicResourceGroupName = tfoNicResourceGroupName;
            IsTfoReuseExistingNicAllowed = isTfoReuseExistingNicAllowed;
            TargetNicName = targetNicName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The nic Id. </summary>
        public string NicId { get; set; }
        /// <summary> The IP configurations to be used by NIC during test failover and failover. </summary>
        public IList<HyperVFailoverIPConfigDetails> IPConfigs { get; }
        /// <summary> Selection type for failover. </summary>
        public string SelectionType { get; set; }
        /// <summary> The id of the NSG associated with the NIC. </summary>
        public string RecoveryNetworkSecurityGroupId { get; set; }
        /// <summary> Whether the NIC has accelerated networking enabled. </summary>
        public bool? IsAcceleratedNetworkingOnRecoveryEnabled { get; set; }
        /// <summary> The NSG to be used by NIC during test failover. </summary>
        public string TfoNetworkSecurityGroupId { get; set; }
        /// <summary> Whether the test NIC has accelerated networking enabled. </summary>
        public bool? IsAcceleratedNetworkingOnTfoEnabled { get; set; }
        /// <summary> The name of the NIC to be used when creating target NICs. </summary>
        public string RecoveryNicName { get; set; }
        /// <summary> The resource group of the NIC to be used when creating target NICs. </summary>
        public string RecoveryNicResourceGroupName { get; set; }
        /// <summary> A value indicating whether an existing NIC is allowed to be reused during failover subject to availability. </summary>
        public bool? IsReuseExistingNicAllowed { get; set; }
        /// <summary> The name of the NIC to be used when creating target NICs in TFO. </summary>
        public string TfoNicName { get; set; }
        /// <summary> The resource group of the NIC to be used when creating target NICs in TFO. </summary>
        public string TfoNicResourceGroupName { get; set; }
        /// <summary> A value indicating whether an existing NIC is allowed to be reused during test failover subject to availability. </summary>
        public bool? IsTfoReuseExistingNicAllowed { get; set; }
        /// <summary> Target NIC name. </summary>
        public string TargetNicName { get; set; }
    }
}
