// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Input to create vault setting. </summary>
    public partial class VaultSettingCreationProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VaultSettingCreationProperties"/>. </summary>
        public VaultSettingCreationProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VaultSettingCreationProperties"/>. </summary>
        /// <param name="migrationSolutionId"> The migration solution Id. </param>
        /// <param name="vmwareToAzureProviderType"> VMware to Azure provider type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VaultSettingCreationProperties(ResourceIdentifier migrationSolutionId, string vmwareToAzureProviderType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MigrationSolutionId = migrationSolutionId;
            VMwareToAzureProviderType = vmwareToAzureProviderType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The migration solution Id. </summary>
        public ResourceIdentifier MigrationSolutionId { get; set; }
        /// <summary> VMware to Azure provider type. </summary>
        public string VMwareToAzureProviderType { get; set; }
    }
}
