// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Store the fabric details specific to the VMware fabric. </summary>
    public partial class VMwareDetails : FabricSpecificDetails
    {
        /// <summary> Initializes a new instance of <see cref="VMwareDetails"/>. </summary>
        internal VMwareDetails()
        {
            ProcessServers = new ChangeTrackingList<SiteRecoveryProcessServer>();
            MasterTargetServers = new ChangeTrackingList<MasterTargetServer>();
            RunAsAccounts = new ChangeTrackingList<SiteRecoveryRunAsAccount>();
            SwitchProviderBlockingErrorDetails = new ChangeTrackingList<InMageFabricSwitchProviderBlockingErrorDetails>();
            InstanceType = "VMware";
        }

        /// <summary> Initializes a new instance of <see cref="VMwareDetails"/>. </summary>
        /// <param name="instanceType"> Gets the class type. Overridden in derived classes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="processServers"> The list of Process Servers associated with the fabric. </param>
        /// <param name="masterTargetServers"> The list of Master Target servers associated with the fabric. </param>
        /// <param name="runAsAccounts"> The list of run as accounts created on the server. </param>
        /// <param name="replicationPairCount"> The number of replication pairs configured in this CS. </param>
        /// <param name="processServerCount"> The number of process servers. </param>
        /// <param name="agentCount"> The number of source and target servers configured to talk to this CS. </param>
        /// <param name="protectedServers"> The number of protected servers. </param>
        /// <param name="systemLoad"> The percentage of the system load. </param>
        /// <param name="systemLoadStatus"> The system load status. </param>
        /// <param name="cpuLoad"> The percentage of the CPU load. </param>
        /// <param name="cpuLoadStatus"> The CPU load status. </param>
        /// <param name="totalMemoryInBytes"> The total memory. </param>
        /// <param name="availableMemoryInBytes"> The available memory. </param>
        /// <param name="memoryUsageStatus"> The memory usage status. </param>
        /// <param name="totalSpaceInBytes"> The total space. </param>
        /// <param name="availableSpaceInBytes"> The available space. </param>
        /// <param name="spaceUsageStatus"> The space usage status. </param>
        /// <param name="webLoad"> The web load. </param>
        /// <param name="webLoadStatus"> The web load status. </param>
        /// <param name="databaseServerLoad"> The database server load. </param>
        /// <param name="databaseServerLoadStatus"> The database server load status. </param>
        /// <param name="csServiceStatus"> The CS service status. </param>
        /// <param name="ipAddress"> The IP address. </param>
        /// <param name="agentVersion"> The agent Version. </param>
        /// <param name="hostName"> The host name. </param>
        /// <param name="lastHeartbeat"> The last heartbeat received from CS server. </param>
        /// <param name="versionStatus"> Version status. </param>
        /// <param name="sslCertExpireOn"> CS SSL cert expiry date. </param>
        /// <param name="sslCertExpiryRemainingDays"> CS SSL cert expiry date. </param>
        /// <param name="psTemplateVersion"> PS template version. </param>
        /// <param name="agentExpireOn"> Agent expiry date. </param>
        /// <param name="agentVersionDetails"> The agent version details. </param>
        /// <param name="switchProviderBlockingErrorDetails"> The switch provider blocking error information. </param>
        internal VMwareDetails(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, IReadOnlyList<SiteRecoveryProcessServer> processServers, IReadOnlyList<MasterTargetServer> masterTargetServers, IReadOnlyList<SiteRecoveryRunAsAccount> runAsAccounts, string replicationPairCount, string processServerCount, string agentCount, string protectedServers, string systemLoad, string systemLoadStatus, string cpuLoad, string cpuLoadStatus, long? totalMemoryInBytes, long? availableMemoryInBytes, string memoryUsageStatus, long? totalSpaceInBytes, long? availableSpaceInBytes, string spaceUsageStatus, string webLoad, string webLoadStatus, string databaseServerLoad, string databaseServerLoadStatus, string csServiceStatus, IPAddress ipAddress, string agentVersion, string hostName, DateTimeOffset? lastHeartbeat, string versionStatus, DateTimeOffset? sslCertExpireOn, int? sslCertExpiryRemainingDays, string psTemplateVersion, DateTimeOffset? agentExpireOn, SiteRecoveryVersionDetails agentVersionDetails, IReadOnlyList<InMageFabricSwitchProviderBlockingErrorDetails> switchProviderBlockingErrorDetails) : base(instanceType, serializedAdditionalRawData)
        {
            ProcessServers = processServers;
            MasterTargetServers = masterTargetServers;
            RunAsAccounts = runAsAccounts;
            ReplicationPairCount = replicationPairCount;
            ProcessServerCount = processServerCount;
            AgentCount = agentCount;
            ProtectedServers = protectedServers;
            SystemLoad = systemLoad;
            SystemLoadStatus = systemLoadStatus;
            CpuLoad = cpuLoad;
            CpuLoadStatus = cpuLoadStatus;
            TotalMemoryInBytes = totalMemoryInBytes;
            AvailableMemoryInBytes = availableMemoryInBytes;
            MemoryUsageStatus = memoryUsageStatus;
            TotalSpaceInBytes = totalSpaceInBytes;
            AvailableSpaceInBytes = availableSpaceInBytes;
            SpaceUsageStatus = spaceUsageStatus;
            WebLoad = webLoad;
            WebLoadStatus = webLoadStatus;
            DatabaseServerLoad = databaseServerLoad;
            DatabaseServerLoadStatus = databaseServerLoadStatus;
            CsServiceStatus = csServiceStatus;
            IPAddress = ipAddress;
            AgentVersion = agentVersion;
            HostName = hostName;
            LastHeartbeat = lastHeartbeat;
            VersionStatus = versionStatus;
            SslCertExpireOn = sslCertExpireOn;
            SslCertExpiryRemainingDays = sslCertExpiryRemainingDays;
            PSTemplateVersion = psTemplateVersion;
            AgentExpireOn = agentExpireOn;
            AgentVersionDetails = agentVersionDetails;
            SwitchProviderBlockingErrorDetails = switchProviderBlockingErrorDetails;
            InstanceType = instanceType ?? "VMware";
        }

        /// <summary> The list of Process Servers associated with the fabric. </summary>
        public IReadOnlyList<SiteRecoveryProcessServer> ProcessServers { get; }
        /// <summary> The list of Master Target servers associated with the fabric. </summary>
        public IReadOnlyList<MasterTargetServer> MasterTargetServers { get; }
        /// <summary> The list of run as accounts created on the server. </summary>
        public IReadOnlyList<SiteRecoveryRunAsAccount> RunAsAccounts { get; }
        /// <summary> The number of replication pairs configured in this CS. </summary>
        public string ReplicationPairCount { get; }
        /// <summary> The number of process servers. </summary>
        public string ProcessServerCount { get; }
        /// <summary> The number of source and target servers configured to talk to this CS. </summary>
        public string AgentCount { get; }
        /// <summary> The number of protected servers. </summary>
        public string ProtectedServers { get; }
        /// <summary> The percentage of the system load. </summary>
        public string SystemLoad { get; }
        /// <summary> The system load status. </summary>
        public string SystemLoadStatus { get; }
        /// <summary> The percentage of the CPU load. </summary>
        public string CpuLoad { get; }
        /// <summary> The CPU load status. </summary>
        public string CpuLoadStatus { get; }
        /// <summary> The total memory. </summary>
        public long? TotalMemoryInBytes { get; }
        /// <summary> The available memory. </summary>
        public long? AvailableMemoryInBytes { get; }
        /// <summary> The memory usage status. </summary>
        public string MemoryUsageStatus { get; }
        /// <summary> The total space. </summary>
        public long? TotalSpaceInBytes { get; }
        /// <summary> The available space. </summary>
        public long? AvailableSpaceInBytes { get; }
        /// <summary> The space usage status. </summary>
        public string SpaceUsageStatus { get; }
        /// <summary> The web load. </summary>
        public string WebLoad { get; }
        /// <summary> The web load status. </summary>
        public string WebLoadStatus { get; }
        /// <summary> The database server load. </summary>
        public string DatabaseServerLoad { get; }
        /// <summary> The database server load status. </summary>
        public string DatabaseServerLoadStatus { get; }
        /// <summary> The CS service status. </summary>
        public string CsServiceStatus { get; }
        /// <summary> The IP address. </summary>
        public IPAddress IPAddress { get; }
        /// <summary> The agent Version. </summary>
        public string AgentVersion { get; }
        /// <summary> The host name. </summary>
        public string HostName { get; }
        /// <summary> The last heartbeat received from CS server. </summary>
        public DateTimeOffset? LastHeartbeat { get; }
        /// <summary> Version status. </summary>
        public string VersionStatus { get; }
        /// <summary> CS SSL cert expiry date. </summary>
        public DateTimeOffset? SslCertExpireOn { get; }
        /// <summary> CS SSL cert expiry date. </summary>
        public int? SslCertExpiryRemainingDays { get; }
        /// <summary> PS template version. </summary>
        public string PSTemplateVersion { get; }
        /// <summary> Agent expiry date. </summary>
        public DateTimeOffset? AgentExpireOn { get; }
        /// <summary> The agent version details. </summary>
        public SiteRecoveryVersionDetails AgentVersionDetails { get; }
        /// <summary> The switch provider blocking error information. </summary>
        public IReadOnlyList<InMageFabricSwitchProviderBlockingErrorDetails> SwitchProviderBlockingErrorDetails { get; }
    }
}
