// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> VMwareCbt specific test migrate input. </summary>
    public partial class VMwareCbtTestMigrateContent : TestMigrateProviderSpecificContent
    {
        /// <summary> Initializes a new instance of <see cref="VMwareCbtTestMigrateContent"/>. </summary>
        /// <param name="recoveryPointId"> The recovery point Id. </param>
        /// <param name="networkId"> The test network Id. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="recoveryPointId"/> or <paramref name="networkId"/> is null. </exception>
        public VMwareCbtTestMigrateContent(ResourceIdentifier recoveryPointId, ResourceIdentifier networkId)
        {
            Argument.AssertNotNull(recoveryPointId, nameof(recoveryPointId));
            Argument.AssertNotNull(networkId, nameof(networkId));

            RecoveryPointId = recoveryPointId;
            NetworkId = networkId;
            VmNics = new ChangeTrackingList<VMwareCbtNicContent>();
            InstanceType = "VMwareCbt";
        }

        /// <summary> Initializes a new instance of <see cref="VMwareCbtTestMigrateContent"/>. </summary>
        /// <param name="instanceType"> The class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="recoveryPointId"> The recovery point Id. </param>
        /// <param name="networkId"> The test network Id. </param>
        /// <param name="vmNics"> The list of NIC details. </param>
        /// <param name="osUpgradeVersion"> A value indicating the inplace OS Upgrade version. </param>
        internal VMwareCbtTestMigrateContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier recoveryPointId, ResourceIdentifier networkId, IList<VMwareCbtNicContent> vmNics, string osUpgradeVersion) : base(instanceType, serializedAdditionalRawData)
        {
            RecoveryPointId = recoveryPointId;
            NetworkId = networkId;
            VmNics = vmNics;
            OSUpgradeVersion = osUpgradeVersion;
            InstanceType = instanceType ?? "VMwareCbt";
        }

        /// <summary> Initializes a new instance of <see cref="VMwareCbtTestMigrateContent"/> for deserialization. </summary>
        internal VMwareCbtTestMigrateContent()
        {
        }

        /// <summary> The recovery point Id. </summary>
        public ResourceIdentifier RecoveryPointId { get; }
        /// <summary> The test network Id. </summary>
        public ResourceIdentifier NetworkId { get; }
        /// <summary> The list of NIC details. </summary>
        public IList<VMwareCbtNicContent> VmNics { get; }
        /// <summary> A value indicating the inplace OS Upgrade version. </summary>
        public string OSUpgradeVersion { get; set; }
    }
}
