// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> VMwareCbt provider specific settings. </summary>
    public partial class VMwareCbtMigrationDetails : MigrationProviderSpecificSettings
    {
        /// <summary> Initializes a new instance of <see cref="VMwareCbtMigrationDetails"/>. </summary>
        internal VMwareCbtMigrationDetails()
        {
            TargetVmTags = new ChangeTrackingDictionary<string, string>();
            ProtectedDisks = new ChangeTrackingList<VMwareCbtProtectedDiskDetails>();
            VmNics = new ChangeTrackingList<VMwareCbtNicDetails>();
            TargetNicTags = new ChangeTrackingDictionary<string, string>();
            SeedDiskTags = new ChangeTrackingDictionary<string, string>();
            TargetDiskTags = new ChangeTrackingDictionary<string, string>();
            SupportedOSVersions = new ChangeTrackingList<string>();
            InstanceType = "VMwareCbt";
        }

        /// <summary> Initializes a new instance of <see cref="VMwareCbtMigrationDetails"/>. </summary>
        /// <param name="instanceType"> Gets the instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="vmwareMachineId"> The ARM Id of the VM discovered in VMware. </param>
        /// <param name="osType"> The type of the OS on the VM. </param>
        /// <param name="osName"> The name of the OS on the VM. </param>
        /// <param name="firmwareType"> The firmware type. </param>
        /// <param name="targetGeneration"> The target generation. </param>
        /// <param name="licenseType"> License Type of the VM to be used. </param>
        /// <param name="sqlServerLicenseType"> The SQL Server license type. </param>
        /// <param name="dataMoverRunAsAccountId"> The data mover run as account Id. </param>
        /// <param name="snapshotRunAsAccountId"> The snapshot run as account Id. </param>
        /// <param name="storageAccountId"> The replication storage account ARM Id. This is applicable only for the blob based replication test hook. </param>
        /// <param name="targetVmName"> Target VM name. </param>
        /// <param name="targetVmSize"> The target VM size. </param>
        /// <param name="targetLocation"> The target location. </param>
        /// <param name="targetResourceGroupId"> The target resource group Id. </param>
        /// <param name="targetAvailabilitySetId"> The target availability set Id. </param>
        /// <param name="targetAvailabilityZone"> The target availability zone. </param>
        /// <param name="targetProximityPlacementGroupId"> The target proximity placement group Id. </param>
        /// <param name="confidentialVmKeyVaultId"> The confidential VM key vault Id for ADE installation. </param>
        /// <param name="targetVmSecurityProfile"> The target VM security profile. </param>
        /// <param name="targetBootDiagnosticsStorageAccountId"> The target boot diagnostics storage account ARM Id. </param>
        /// <param name="targetVmTags"> The target VM tags. </param>
        /// <param name="protectedDisks"> The list of protected disks. </param>
        /// <param name="targetNetworkId"> The target network Id. </param>
        /// <param name="testNetworkId"> The test network Id. </param>
        /// <param name="vmNics"> The network details. </param>
        /// <param name="targetNicTags"> The tags for the target NICs. </param>
        /// <param name="migrationRecoveryPointId"> The recovery point Id to which the VM was migrated. </param>
        /// <param name="lastRecoveryPointReceived"> The last recovery point received time. </param>
        /// <param name="lastRecoveryPointId"> The last recovery point Id. </param>
        /// <param name="initialSeedingProgressPercentage"> The initial seeding progress percentage. </param>
        /// <param name="migrationProgressPercentage"> The migration progress percentage. </param>
        /// <param name="resyncProgressPercentage"> The resync progress percentage. </param>
        /// <param name="resumeProgressPercentage"> The resume progress percentage. </param>
        /// <param name="deltaSyncProgressPercentage"> The delta sync progress percentage. </param>
        /// <param name="isCheckSumResyncCycle"> A value indicating whether checksum resync cycle is in progress. </param>
        /// <param name="initialSeedingRetryCount"> The initial seeding retry count. </param>
        /// <param name="resyncRetryCount"> The resync retry count. </param>
        /// <param name="resumeRetryCount"> The resume retry count. </param>
        /// <param name="deltaSyncRetryCount"> The delta sync retry count. </param>
        /// <param name="resyncRequired"> A value indicating whether resync is required. </param>
        /// <param name="resyncState"> The resync state. </param>
        /// <param name="performAutoResync"> A value indicating whether auto resync is to be done. </param>
        /// <param name="seedDiskTags"> The tags for the seed disks. </param>
        /// <param name="targetDiskTags"> The tags for the target disks. </param>
        /// <param name="supportedOSVersions"> A value indicating the inplace OS Upgrade version. </param>
        /// <param name="applianceMonitoringDetails"> A value indicating the appliance monitoring details. </param>
        /// <param name="gatewayOperationDetails"> A value indicating the gateway operation details. </param>
        /// <param name="operationName"> A value indicating the SRS operation name. </param>
        internal VMwareCbtMigrationDetails(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier vmwareMachineId, string osType, string osName, string firmwareType, string targetGeneration, string licenseType, string sqlServerLicenseType, ResourceIdentifier dataMoverRunAsAccountId, ResourceIdentifier snapshotRunAsAccountId, ResourceIdentifier storageAccountId, string targetVmName, string targetVmSize, string targetLocation, ResourceIdentifier targetResourceGroupId, ResourceIdentifier targetAvailabilitySetId, string targetAvailabilityZone, ResourceIdentifier targetProximityPlacementGroupId, ResourceIdentifier confidentialVmKeyVaultId, VMwareCbtSecurityProfileProperties targetVmSecurityProfile, ResourceIdentifier targetBootDiagnosticsStorageAccountId, IReadOnlyDictionary<string, string> targetVmTags, IReadOnlyList<VMwareCbtProtectedDiskDetails> protectedDisks, ResourceIdentifier targetNetworkId, ResourceIdentifier testNetworkId, IReadOnlyList<VMwareCbtNicDetails> vmNics, IReadOnlyDictionary<string, string> targetNicTags, ResourceIdentifier migrationRecoveryPointId, DateTimeOffset? lastRecoveryPointReceived, ResourceIdentifier lastRecoveryPointId, int? initialSeedingProgressPercentage, int? migrationProgressPercentage, int? resyncProgressPercentage, int? resumeProgressPercentage, int? deltaSyncProgressPercentage, string isCheckSumResyncCycle, long? initialSeedingRetryCount, long? resyncRetryCount, long? resumeRetryCount, long? deltaSyncRetryCount, string resyncRequired, SiteRecoveryResyncState? resyncState, string performAutoResync, IReadOnlyDictionary<string, string> seedDiskTags, IReadOnlyDictionary<string, string> targetDiskTags, IReadOnlyList<string> supportedOSVersions, ApplianceMonitoringDetails applianceMonitoringDetails, GatewayOperationDetails gatewayOperationDetails, string operationName) : base(instanceType, serializedAdditionalRawData)
        {
            VMwareMachineId = vmwareMachineId;
            OSType = osType;
            OSName = osName;
            FirmwareType = firmwareType;
            TargetGeneration = targetGeneration;
            LicenseType = licenseType;
            SqlServerLicenseType = sqlServerLicenseType;
            DataMoverRunAsAccountId = dataMoverRunAsAccountId;
            SnapshotRunAsAccountId = snapshotRunAsAccountId;
            StorageAccountId = storageAccountId;
            TargetVmName = targetVmName;
            TargetVmSize = targetVmSize;
            TargetLocation = targetLocation;
            TargetResourceGroupId = targetResourceGroupId;
            TargetAvailabilitySetId = targetAvailabilitySetId;
            TargetAvailabilityZone = targetAvailabilityZone;
            TargetProximityPlacementGroupId = targetProximityPlacementGroupId;
            ConfidentialVmKeyVaultId = confidentialVmKeyVaultId;
            TargetVmSecurityProfile = targetVmSecurityProfile;
            TargetBootDiagnosticsStorageAccountId = targetBootDiagnosticsStorageAccountId;
            TargetVmTags = targetVmTags;
            ProtectedDisks = protectedDisks;
            TargetNetworkId = targetNetworkId;
            TestNetworkId = testNetworkId;
            VmNics = vmNics;
            TargetNicTags = targetNicTags;
            MigrationRecoveryPointId = migrationRecoveryPointId;
            LastRecoveryPointReceived = lastRecoveryPointReceived;
            LastRecoveryPointId = lastRecoveryPointId;
            InitialSeedingProgressPercentage = initialSeedingProgressPercentage;
            MigrationProgressPercentage = migrationProgressPercentage;
            ResyncProgressPercentage = resyncProgressPercentage;
            ResumeProgressPercentage = resumeProgressPercentage;
            DeltaSyncProgressPercentage = deltaSyncProgressPercentage;
            IsCheckSumResyncCycle = isCheckSumResyncCycle;
            InitialSeedingRetryCount = initialSeedingRetryCount;
            ResyncRetryCount = resyncRetryCount;
            ResumeRetryCount = resumeRetryCount;
            DeltaSyncRetryCount = deltaSyncRetryCount;
            ResyncRequired = resyncRequired;
            ResyncState = resyncState;
            PerformAutoResync = performAutoResync;
            SeedDiskTags = seedDiskTags;
            TargetDiskTags = targetDiskTags;
            SupportedOSVersions = supportedOSVersions;
            ApplianceMonitoringDetails = applianceMonitoringDetails;
            GatewayOperationDetails = gatewayOperationDetails;
            OperationName = operationName;
            InstanceType = instanceType ?? "VMwareCbt";
        }

        /// <summary> The ARM Id of the VM discovered in VMware. </summary>
        public ResourceIdentifier VMwareMachineId { get; }
        /// <summary> The type of the OS on the VM. </summary>
        public string OSType { get; }
        /// <summary> The name of the OS on the VM. </summary>
        public string OSName { get; }
        /// <summary> The firmware type. </summary>
        public string FirmwareType { get; }
        /// <summary> The target generation. </summary>
        public string TargetGeneration { get; }
        /// <summary> License Type of the VM to be used. </summary>
        public string LicenseType { get; }
        /// <summary> The SQL Server license type. </summary>
        public string SqlServerLicenseType { get; }
        /// <summary> The data mover run as account Id. </summary>
        public ResourceIdentifier DataMoverRunAsAccountId { get; }
        /// <summary> The snapshot run as account Id. </summary>
        public ResourceIdentifier SnapshotRunAsAccountId { get; }
        /// <summary> The replication storage account ARM Id. This is applicable only for the blob based replication test hook. </summary>
        public ResourceIdentifier StorageAccountId { get; }
        /// <summary> Target VM name. </summary>
        public string TargetVmName { get; }
        /// <summary> The target VM size. </summary>
        public string TargetVmSize { get; }
        /// <summary> The target location. </summary>
        public string TargetLocation { get; }
        /// <summary> The target resource group Id. </summary>
        public ResourceIdentifier TargetResourceGroupId { get; }
        /// <summary> The target availability set Id. </summary>
        public ResourceIdentifier TargetAvailabilitySetId { get; }
        /// <summary> The target availability zone. </summary>
        public string TargetAvailabilityZone { get; }
        /// <summary> The target proximity placement group Id. </summary>
        public ResourceIdentifier TargetProximityPlacementGroupId { get; }
        /// <summary> The confidential VM key vault Id for ADE installation. </summary>
        public ResourceIdentifier ConfidentialVmKeyVaultId { get; }
        /// <summary> The target VM security profile. </summary>
        public VMwareCbtSecurityProfileProperties TargetVmSecurityProfile { get; }
        /// <summary> The target boot diagnostics storage account ARM Id. </summary>
        public ResourceIdentifier TargetBootDiagnosticsStorageAccountId { get; }
        /// <summary> The target VM tags. </summary>
        public IReadOnlyDictionary<string, string> TargetVmTags { get; }
        /// <summary> The list of protected disks. </summary>
        public IReadOnlyList<VMwareCbtProtectedDiskDetails> ProtectedDisks { get; }
        /// <summary> The target network Id. </summary>
        public ResourceIdentifier TargetNetworkId { get; }
        /// <summary> The test network Id. </summary>
        public ResourceIdentifier TestNetworkId { get; }
        /// <summary> The network details. </summary>
        public IReadOnlyList<VMwareCbtNicDetails> VmNics { get; }
        /// <summary> The tags for the target NICs. </summary>
        public IReadOnlyDictionary<string, string> TargetNicTags { get; }
        /// <summary> The recovery point Id to which the VM was migrated. </summary>
        public ResourceIdentifier MigrationRecoveryPointId { get; }
        /// <summary> The last recovery point received time. </summary>
        public DateTimeOffset? LastRecoveryPointReceived { get; }
        /// <summary> The last recovery point Id. </summary>
        public ResourceIdentifier LastRecoveryPointId { get; }
        /// <summary> The initial seeding progress percentage. </summary>
        public int? InitialSeedingProgressPercentage { get; }
        /// <summary> The migration progress percentage. </summary>
        public int? MigrationProgressPercentage { get; }
        /// <summary> The resync progress percentage. </summary>
        public int? ResyncProgressPercentage { get; }
        /// <summary> The resume progress percentage. </summary>
        public int? ResumeProgressPercentage { get; }
        /// <summary> The delta sync progress percentage. </summary>
        public int? DeltaSyncProgressPercentage { get; }
        /// <summary> A value indicating whether checksum resync cycle is in progress. </summary>
        public string IsCheckSumResyncCycle { get; }
        /// <summary> The initial seeding retry count. </summary>
        public long? InitialSeedingRetryCount { get; }
        /// <summary> The resync retry count. </summary>
        public long? ResyncRetryCount { get; }
        /// <summary> The resume retry count. </summary>
        public long? ResumeRetryCount { get; }
        /// <summary> The delta sync retry count. </summary>
        public long? DeltaSyncRetryCount { get; }
        /// <summary> A value indicating whether resync is required. </summary>
        public string ResyncRequired { get; }
        /// <summary> The resync state. </summary>
        public SiteRecoveryResyncState? ResyncState { get; }
        /// <summary> A value indicating whether auto resync is to be done. </summary>
        public string PerformAutoResync { get; }
        /// <summary> The tags for the seed disks. </summary>
        public IReadOnlyDictionary<string, string> SeedDiskTags { get; }
        /// <summary> The tags for the target disks. </summary>
        public IReadOnlyDictionary<string, string> TargetDiskTags { get; }
        /// <summary> A value indicating the inplace OS Upgrade version. </summary>
        public IReadOnlyList<string> SupportedOSVersions { get; }
        /// <summary> A value indicating the appliance monitoring details. </summary>
        public ApplianceMonitoringDetails ApplianceMonitoringDetails { get; }
        /// <summary> A value indicating the gateway operation details. </summary>
        public GatewayOperationDetails GatewayOperationDetails { get; }
        /// <summary> A value indicating the SRS operation name. </summary>
        public string OperationName { get; }
    }
}
