// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The test migrate state. </summary>
    public readonly partial struct TestMigrationState : IEquatable<TestMigrationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TestMigrationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TestMigrationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string TestMigrationInProgressValue = "TestMigrationInProgress";
        private const string TestMigrationSucceededValue = "TestMigrationSucceeded";
        private const string TestMigrationFailedValue = "TestMigrationFailed";
        private const string TestMigrationCleanupInProgressValue = "TestMigrationCleanupInProgress";
        private const string TestMigrationCompletedWithInformationValue = "TestMigrationCompletedWithInformation";
        private const string TestMigrationPartiallySucceededValue = "TestMigrationPartiallySucceeded";

        /// <summary> None. </summary>
        public static TestMigrationState None { get; } = new TestMigrationState(NoneValue);
        /// <summary> TestMigrationInProgress. </summary>
        public static TestMigrationState TestMigrationInProgress { get; } = new TestMigrationState(TestMigrationInProgressValue);
        /// <summary> TestMigrationSucceeded. </summary>
        public static TestMigrationState TestMigrationSucceeded { get; } = new TestMigrationState(TestMigrationSucceededValue);
        /// <summary> TestMigrationFailed. </summary>
        public static TestMigrationState TestMigrationFailed { get; } = new TestMigrationState(TestMigrationFailedValue);
        /// <summary> TestMigrationCleanupInProgress. </summary>
        public static TestMigrationState TestMigrationCleanupInProgress { get; } = new TestMigrationState(TestMigrationCleanupInProgressValue);
        /// <summary> TestMigrationCompletedWithInformation. </summary>
        public static TestMigrationState TestMigrationCompletedWithInformation { get; } = new TestMigrationState(TestMigrationCompletedWithInformationValue);
        /// <summary> TestMigrationPartiallySucceeded. </summary>
        public static TestMigrationState TestMigrationPartiallySucceeded { get; } = new TestMigrationState(TestMigrationPartiallySucceededValue);
        /// <summary> Determines if two <see cref="TestMigrationState"/> values are the same. </summary>
        public static bool operator ==(TestMigrationState left, TestMigrationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TestMigrationState"/> values are not the same. </summary>
        public static bool operator !=(TestMigrationState left, TestMigrationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TestMigrationState"/>. </summary>
        public static implicit operator TestMigrationState(string value) => new TestMigrationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TestMigrationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TestMigrationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
