// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Input definition for test failover input properties. </summary>
    public partial class TestFailoverProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TestFailoverProperties"/>. </summary>
        public TestFailoverProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TestFailoverProperties"/>. </summary>
        /// <param name="failoverDirection"> Test failover direction. </param>
        /// <param name="networkType"> Network type to be used for test failover. </param>
        /// <param name="networkId"> The id of the network to be used for test failover. </param>
        /// <param name="providerSpecificDetails">
        /// Provider specific settings.
        /// Please note <see cref="TestFailoverProviderSpecificContent"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="A2ATestFailoverContent"/>, <see cref="HyperVReplicaAzureTestFailoverContent"/>, <see cref="InMageTestFailoverContent"/>, <see cref="InMageAzureV2TestFailoverContent"/> and <see cref="InMageRcmTestFailoverContent"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TestFailoverProperties(string failoverDirection, string networkType, ResourceIdentifier networkId, TestFailoverProviderSpecificContent providerSpecificDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FailoverDirection = failoverDirection;
            NetworkType = networkType;
            NetworkId = networkId;
            ProviderSpecificDetails = providerSpecificDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Test failover direction. </summary>
        public string FailoverDirection { get; set; }
        /// <summary> Network type to be used for test failover. </summary>
        public string NetworkType { get; set; }
        /// <summary> The id of the network to be used for test failover. </summary>
        public ResourceIdentifier NetworkId { get; set; }
        /// <summary>
        /// Provider specific settings.
        /// Please note <see cref="TestFailoverProviderSpecificContent"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="A2ATestFailoverContent"/>, <see cref="HyperVReplicaAzureTestFailoverContent"/>, <see cref="InMageTestFailoverContent"/>, <see cref="InMageAzureV2TestFailoverContent"/> and <see cref="InMageRcmTestFailoverContent"/>.
        /// </summary>
        public TestFailoverProviderSpecificContent ProviderSpecificDetails { get; set; }
    }
}
