// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> A value indicating whether source site operations are required. </summary>
    public readonly partial struct SourceSiteOperation : IEquatable<SourceSiteOperation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SourceSiteOperation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SourceSiteOperation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RequiredValue = "Required";
        private const string NotRequiredValue = "NotRequired";

        /// <summary> Required. </summary>
        public static SourceSiteOperation Required { get; } = new SourceSiteOperation(RequiredValue);
        /// <summary> NotRequired. </summary>
        public static SourceSiteOperation NotRequired { get; } = new SourceSiteOperation(NotRequiredValue);
        /// <summary> Determines if two <see cref="SourceSiteOperation"/> values are the same. </summary>
        public static bool operator ==(SourceSiteOperation left, SourceSiteOperation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SourceSiteOperation"/> values are not the same. </summary>
        public static bool operator !=(SourceSiteOperation left, SourceSiteOperation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SourceSiteOperation"/>. </summary>
        public static implicit operator SourceSiteOperation(string value) => new SourceSiteOperation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SourceSiteOperation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SourceSiteOperation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
