// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The target VM security type. </summary>
    public readonly partial struct SiteRecoveryVmSecurityType : IEquatable<SiteRecoveryVmSecurityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryVmSecurityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SiteRecoveryVmSecurityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string TrustedLaunchValue = "TrustedLaunch";
        private const string ConfidentialVmValue = "ConfidentialVM";

        /// <summary> None. </summary>
        public static SiteRecoveryVmSecurityType None { get; } = new SiteRecoveryVmSecurityType(NoneValue);
        /// <summary> TrustedLaunch. </summary>
        public static SiteRecoveryVmSecurityType TrustedLaunch { get; } = new SiteRecoveryVmSecurityType(TrustedLaunchValue);
        /// <summary> ConfidentialVM. </summary>
        public static SiteRecoveryVmSecurityType ConfidentialVm { get; } = new SiteRecoveryVmSecurityType(ConfidentialVmValue);
        /// <summary> Determines if two <see cref="SiteRecoveryVmSecurityType"/> values are the same. </summary>
        public static bool operator ==(SiteRecoveryVmSecurityType left, SiteRecoveryVmSecurityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SiteRecoveryVmSecurityType"/> values are not the same. </summary>
        public static bool operator !=(SiteRecoveryVmSecurityType left, SiteRecoveryVmSecurityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SiteRecoveryVmSecurityType"/>. </summary>
        public static implicit operator SiteRecoveryVmSecurityType(string value) => new SiteRecoveryVmSecurityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SiteRecoveryVmSecurityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SiteRecoveryVmSecurityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
