// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The SiteRecoveryVmEndpoint. </summary>
    public partial class SiteRecoveryVmEndpoint
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryVmEndpoint"/>. </summary>
        internal SiteRecoveryVmEndpoint()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryVmEndpoint"/>. </summary>
        /// <param name="endpointName"></param>
        /// <param name="privatePort"></param>
        /// <param name="publicPort"></param>
        /// <param name="protocol"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoveryVmEndpoint(string endpointName, int? privatePort, int? publicPort, string protocol, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EndpointName = endpointName;
            PrivatePort = privatePort;
            PublicPort = publicPort;
            Protocol = protocol;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the endpoint name. </summary>
        public string EndpointName { get; }
        /// <summary> Gets the private port. </summary>
        public int? PrivatePort { get; }
        /// <summary> Gets the public port. </summary>
        public int? PublicPort { get; }
        /// <summary> Gets the protocol. </summary>
        public string Protocol { get; }
    }
}
