// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Version related details. </summary>
    public partial class SiteRecoveryVersionDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryVersionDetails"/>. </summary>
        internal SiteRecoveryVersionDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryVersionDetails"/>. </summary>
        /// <param name="version"> The agent version. </param>
        /// <param name="expireOn"> Version expiry date. </param>
        /// <param name="status"> A value indicating whether security update required. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoveryVersionDetails(string version, DateTimeOffset? expireOn, SiteRecoveryAgentVersionStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Version = version;
            ExpireOn = expireOn;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The agent version. </summary>
        public string Version { get; }
        /// <summary> Version expiry date. </summary>
        public DateTimeOffset? ExpireOn { get; }
        /// <summary> A value indicating whether security update required. </summary>
        public SiteRecoveryAgentVersionStatus? Status { get; }
    }
}
