// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    public partial class SiteRecoverySupportedOSProperty : IUtf8JsonSerializable, IJsonModel<SiteRecoverySupportedOSProperty>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SiteRecoverySupportedOSProperty>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SiteRecoverySupportedOSProperty>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoverySupportedOSProperty>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SiteRecoverySupportedOSProperty)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(InstanceType))
            {
                writer.WritePropertyName("instanceType"u8);
                writer.WriteStringValue(InstanceType);
            }
            if (Optional.IsCollectionDefined(SupportedOS))
            {
                writer.WritePropertyName("supportedOs"u8);
                writer.WriteStartArray();
                foreach (var item in SupportedOS)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SiteRecoverySupportedOSProperty IJsonModel<SiteRecoverySupportedOSProperty>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoverySupportedOSProperty>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SiteRecoverySupportedOSProperty)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSiteRecoverySupportedOSProperty(document.RootElement, options);
        }

        internal static SiteRecoverySupportedOSProperty DeserializeSiteRecoverySupportedOSProperty(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string instanceType = default;
            IReadOnlyList<SiteRecoverySupportedOSDetails> supportedOS = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("instanceType"u8))
                {
                    instanceType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("supportedOs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SiteRecoverySupportedOSDetails> array = new List<SiteRecoverySupportedOSDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SiteRecoverySupportedOSDetails.DeserializeSiteRecoverySupportedOSDetails(item, options));
                    }
                    supportedOS = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SiteRecoverySupportedOSProperty(instanceType, supportedOS ?? new ChangeTrackingList<SiteRecoverySupportedOSDetails>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SiteRecoverySupportedOSProperty>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoverySupportedOSProperty>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SiteRecoverySupportedOSProperty)} does not support writing '{options.Format}' format.");
            }
        }

        SiteRecoverySupportedOSProperty IPersistableModel<SiteRecoverySupportedOSProperty>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoverySupportedOSProperty>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSiteRecoverySupportedOSProperty(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SiteRecoverySupportedOSProperty)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SiteRecoverySupportedOSProperty>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
