// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Supported operating system details. </summary>
    public partial class SiteRecoverySupportedOSDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoverySupportedOSDetails"/>. </summary>
        internal SiteRecoverySupportedOSDetails()
        {
            OSVersions = new ChangeTrackingList<SiteRecoveryOSVersionWrapper>();
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoverySupportedOSDetails"/>. </summary>
        /// <param name="osName"> The name. </param>
        /// <param name="osType"> The type. </param>
        /// <param name="osVersions"> The list of version for operating system. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoverySupportedOSDetails(string osName, string osType, IReadOnlyList<SiteRecoveryOSVersionWrapper> osVersions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OSName = osName;
            OSType = osType;
            OSVersions = osVersions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name. </summary>
        public string OSName { get; }
        /// <summary> The type. </summary>
        public string OSType { get; }
        /// <summary> The list of version for operating system. </summary>
        public IReadOnlyList<SiteRecoveryOSVersionWrapper> OSVersions { get; }
    }
}
