// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Subnets of the network. </summary>
    public partial class SiteRecoverySubnet
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoverySubnet"/>. </summary>
        internal SiteRecoverySubnet()
        {
            AddressList = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoverySubnet"/>. </summary>
        /// <param name="name"> The subnet name. </param>
        /// <param name="friendlyName"> The subnet friendly name. </param>
        /// <param name="addressList"> The list of addresses for the subnet. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoverySubnet(string name, string friendlyName, IReadOnlyList<string> addressList, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            FriendlyName = friendlyName;
            AddressList = addressList;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The subnet name. </summary>
        public string Name { get; }
        /// <summary> The subnet friendly name. </summary>
        public string FriendlyName { get; }
        /// <summary> The list of addresses for the subnet. </summary>
        public IReadOnlyList<string> AddressList { get; }
    }
}
