// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The SQL Server license type. </summary>
    public readonly partial struct SiteRecoverySqlServerLicenseType : IEquatable<SiteRecoverySqlServerLicenseType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SiteRecoverySqlServerLicenseType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SiteRecoverySqlServerLicenseType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string NoLicenseTypeValue = "NoLicenseType";
        private const string PaygValue = "PAYG";
        private const string AhubValue = "AHUB";

        /// <summary> NotSpecified. </summary>
        public static SiteRecoverySqlServerLicenseType NotSpecified { get; } = new SiteRecoverySqlServerLicenseType(NotSpecifiedValue);
        /// <summary> NoLicenseType. </summary>
        public static SiteRecoverySqlServerLicenseType NoLicenseType { get; } = new SiteRecoverySqlServerLicenseType(NoLicenseTypeValue);
        /// <summary> PAYG. </summary>
        public static SiteRecoverySqlServerLicenseType Payg { get; } = new SiteRecoverySqlServerLicenseType(PaygValue);
        /// <summary> AHUB. </summary>
        public static SiteRecoverySqlServerLicenseType Ahub { get; } = new SiteRecoverySqlServerLicenseType(AhubValue);
        /// <summary> Determines if two <see cref="SiteRecoverySqlServerLicenseType"/> values are the same. </summary>
        public static bool operator ==(SiteRecoverySqlServerLicenseType left, SiteRecoverySqlServerLicenseType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SiteRecoverySqlServerLicenseType"/> values are not the same. </summary>
        public static bool operator !=(SiteRecoverySqlServerLicenseType left, SiteRecoverySqlServerLicenseType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SiteRecoverySqlServerLicenseType"/>. </summary>
        public static implicit operator SiteRecoverySqlServerLicenseType(string value) => new SiteRecoverySqlServerLicenseType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SiteRecoverySqlServerLicenseType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SiteRecoverySqlServerLicenseType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
