// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Recovery services provider properties. </summary>
    public partial class SiteRecoveryServicesProviderProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryServicesProviderProperties"/>. </summary>
        internal SiteRecoveryServicesProviderProperties()
        {
            AllowedScenarios = new ChangeTrackingList<string>();
            HealthErrorDetails = new ChangeTrackingList<SiteRecoveryHealthError>();
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryServicesProviderProperties"/>. </summary>
        /// <param name="fabricType"> Type of the site. </param>
        /// <param name="friendlyName"> Friendly name of the DRA. </param>
        /// <param name="providerVersion"> The provider version. </param>
        /// <param name="serverVersion"> The fabric provider. </param>
        /// <param name="providerVersionState"> DRA version status. </param>
        /// <param name="providerVersionExpireOn"> Expiry date of the version. </param>
        /// <param name="fabricFriendlyName"> The fabric friendly name. </param>
        /// <param name="lastHeartbeatReceivedOn"> Time when last heartbeat was sent by the DRA. </param>
        /// <param name="connectionStatus"> A value indicating whether DRA is responsive. </param>
        /// <param name="protectedItemCount"> Number of protected VMs currently managed by the DRA. </param>
        /// <param name="allowedScenarios"> The scenarios allowed on this provider. </param>
        /// <param name="healthErrorDetails"> The recovery services provider health error details. </param>
        /// <param name="draIdentifier"> The DRA Id. </param>
        /// <param name="machineId"> The machine Id. </param>
        /// <param name="machineName"> The machine name. </param>
        /// <param name="biosId"> The Bios Id. </param>
        /// <param name="authenticationIdentityDetails"> The authentication identity details. </param>
        /// <param name="resourceAccessIdentityDetails"> The resource access identity details. </param>
        /// <param name="dataPlaneAuthenticationIdentityDetails"> The data plane authentication identity details. </param>
        /// <param name="providerVersionDetails"> The provider version details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoveryServicesProviderProperties(string fabricType, string friendlyName, string providerVersion, string serverVersion, string providerVersionState, DateTimeOffset? providerVersionExpireOn, string fabricFriendlyName, DateTimeOffset? lastHeartbeatReceivedOn, string connectionStatus, int? protectedItemCount, IReadOnlyList<string> allowedScenarios, IReadOnlyList<SiteRecoveryHealthError> healthErrorDetails, string draIdentifier, string machineId, string machineName, string biosId, IdentityProviderDetails authenticationIdentityDetails, IdentityProviderDetails resourceAccessIdentityDetails, IdentityProviderDetails dataPlaneAuthenticationIdentityDetails, SiteRecoveryVersionDetails providerVersionDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FabricType = fabricType;
            FriendlyName = friendlyName;
            ProviderVersion = providerVersion;
            ServerVersion = serverVersion;
            ProviderVersionState = providerVersionState;
            ProviderVersionExpireOn = providerVersionExpireOn;
            FabricFriendlyName = fabricFriendlyName;
            LastHeartbeatReceivedOn = lastHeartbeatReceivedOn;
            ConnectionStatus = connectionStatus;
            ProtectedItemCount = protectedItemCount;
            AllowedScenarios = allowedScenarios;
            HealthErrorDetails = healthErrorDetails;
            DraIdentifier = draIdentifier;
            MachineId = machineId;
            MachineName = machineName;
            BiosId = biosId;
            AuthenticationIdentityDetails = authenticationIdentityDetails;
            ResourceAccessIdentityDetails = resourceAccessIdentityDetails;
            DataPlaneAuthenticationIdentityDetails = dataPlaneAuthenticationIdentityDetails;
            ProviderVersionDetails = providerVersionDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of the site. </summary>
        public string FabricType { get; }
        /// <summary> Friendly name of the DRA. </summary>
        public string FriendlyName { get; }
        /// <summary> The provider version. </summary>
        public string ProviderVersion { get; }
        /// <summary> The fabric provider. </summary>
        public string ServerVersion { get; }
        /// <summary> DRA version status. </summary>
        public string ProviderVersionState { get; }
        /// <summary> Expiry date of the version. </summary>
        public DateTimeOffset? ProviderVersionExpireOn { get; }
        /// <summary> The fabric friendly name. </summary>
        public string FabricFriendlyName { get; }
        /// <summary> Time when last heartbeat was sent by the DRA. </summary>
        public DateTimeOffset? LastHeartbeatReceivedOn { get; }
        /// <summary> A value indicating whether DRA is responsive. </summary>
        public string ConnectionStatus { get; }
        /// <summary> Number of protected VMs currently managed by the DRA. </summary>
        public int? ProtectedItemCount { get; }
        /// <summary> The scenarios allowed on this provider. </summary>
        public IReadOnlyList<string> AllowedScenarios { get; }
        /// <summary> The recovery services provider health error details. </summary>
        public IReadOnlyList<SiteRecoveryHealthError> HealthErrorDetails { get; }
        /// <summary> The DRA Id. </summary>
        public string DraIdentifier { get; }
        /// <summary> The machine Id. </summary>
        public string MachineId { get; }
        /// <summary> The machine name. </summary>
        public string MachineName { get; }
        /// <summary> The Bios Id. </summary>
        public string BiosId { get; }
        /// <summary> The authentication identity details. </summary>
        public IdentityProviderDetails AuthenticationIdentityDetails { get; }
        /// <summary> The resource access identity details. </summary>
        public IdentityProviderDetails ResourceAccessIdentityDetails { get; }
        /// <summary> The data plane authentication identity details. </summary>
        public IdentityProviderDetails DataPlaneAuthenticationIdentityDetails { get; }
        /// <summary> The provider version details. </summary>
        public SiteRecoveryVersionDetails ProviderVersionDetails { get; }
    }
}
