// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The resync state. </summary>
    public readonly partial struct SiteRecoveryResyncState : IEquatable<SiteRecoveryResyncState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryResyncState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SiteRecoveryResyncState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string PreparedForResynchronizationValue = "PreparedForResynchronization";
        private const string StartedResynchronizationValue = "StartedResynchronization";

        /// <summary> None. </summary>
        public static SiteRecoveryResyncState None { get; } = new SiteRecoveryResyncState(NoneValue);
        /// <summary> PreparedForResynchronization. </summary>
        public static SiteRecoveryResyncState PreparedForResynchronization { get; } = new SiteRecoveryResyncState(PreparedForResynchronizationValue);
        /// <summary> StartedResynchronization. </summary>
        public static SiteRecoveryResyncState StartedResynchronization { get; } = new SiteRecoveryResyncState(StartedResynchronizationValue);
        /// <summary> Determines if two <see cref="SiteRecoveryResyncState"/> values are the same. </summary>
        public static bool operator ==(SiteRecoveryResyncState left, SiteRecoveryResyncState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SiteRecoveryResyncState"/> values are not the same. </summary>
        public static bool operator !=(SiteRecoveryResyncState left, SiteRecoveryResyncState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SiteRecoveryResyncState"/>. </summary>
        public static implicit operator SiteRecoveryResyncState(string value) => new SiteRecoveryResyncState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SiteRecoveryResyncState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SiteRecoveryResyncState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
