// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Recovery plan properties. </summary>
    public partial class SiteRecoveryRecoveryPlanProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryRecoveryPlanProperties"/>. </summary>
        internal SiteRecoveryRecoveryPlanProperties()
        {
            ReplicationProviders = new ChangeTrackingList<string>();
            AllowedOperations = new ChangeTrackingList<string>();
            Groups = new ChangeTrackingList<SiteRecoveryPlanGroup>();
            ProviderSpecificDetails = new ChangeTrackingList<RecoveryPlanProviderSpecificDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryRecoveryPlanProperties"/>. </summary>
        /// <param name="friendlyName"> The friendly name. </param>
        /// <param name="primaryFabricId"> The primary fabric Id. </param>
        /// <param name="primaryFabricFriendlyName"> The primary fabric friendly name. </param>
        /// <param name="recoveryFabricId"> The recovery fabric Id. </param>
        /// <param name="recoveryFabricFriendlyName"> The recovery fabric friendly name. </param>
        /// <param name="failoverDeploymentModel"> The failover deployment model. </param>
        /// <param name="replicationProviders"> The list of replication providers. </param>
        /// <param name="allowedOperations"> The list of allowed operations. </param>
        /// <param name="lastPlannedFailoverOn"> The start time of the last planned failover. </param>
        /// <param name="lastUnplannedFailoverOn"> The start time of the last unplanned failover. </param>
        /// <param name="lastTestFailoverOn"> The start time of the last test failover. </param>
        /// <param name="currentScenario"> The current scenario details. </param>
        /// <param name="currentScenarioStatus"> The recovery plan status. </param>
        /// <param name="currentScenarioStatusDescription"> The recovery plan status description. </param>
        /// <param name="groups"> The recovery plan groups. </param>
        /// <param name="providerSpecificDetails">
        /// The provider id and provider specific details.
        /// Please note <see cref="RecoveryPlanProviderSpecificDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RecoveryPlanA2ADetails"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoveryRecoveryPlanProperties(string friendlyName, ResourceIdentifier primaryFabricId, string primaryFabricFriendlyName, ResourceIdentifier recoveryFabricId, string recoveryFabricFriendlyName, string failoverDeploymentModel, IReadOnlyList<string> replicationProviders, IReadOnlyList<string> allowedOperations, DateTimeOffset? lastPlannedFailoverOn, DateTimeOffset? lastUnplannedFailoverOn, DateTimeOffset? lastTestFailoverOn, CurrentScenarioDetails currentScenario, string currentScenarioStatus, string currentScenarioStatusDescription, IReadOnlyList<SiteRecoveryPlanGroup> groups, IReadOnlyList<RecoveryPlanProviderSpecificDetails> providerSpecificDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FriendlyName = friendlyName;
            PrimaryFabricId = primaryFabricId;
            PrimaryFabricFriendlyName = primaryFabricFriendlyName;
            RecoveryFabricId = recoveryFabricId;
            RecoveryFabricFriendlyName = recoveryFabricFriendlyName;
            FailoverDeploymentModel = failoverDeploymentModel;
            ReplicationProviders = replicationProviders;
            AllowedOperations = allowedOperations;
            LastPlannedFailoverOn = lastPlannedFailoverOn;
            LastUnplannedFailoverOn = lastUnplannedFailoverOn;
            LastTestFailoverOn = lastTestFailoverOn;
            CurrentScenario = currentScenario;
            CurrentScenarioStatus = currentScenarioStatus;
            CurrentScenarioStatusDescription = currentScenarioStatusDescription;
            Groups = groups;
            ProviderSpecificDetails = providerSpecificDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The friendly name. </summary>
        public string FriendlyName { get; }
        /// <summary> The primary fabric Id. </summary>
        public ResourceIdentifier PrimaryFabricId { get; }
        /// <summary> The primary fabric friendly name. </summary>
        public string PrimaryFabricFriendlyName { get; }
        /// <summary> The recovery fabric Id. </summary>
        public ResourceIdentifier RecoveryFabricId { get; }
        /// <summary> The recovery fabric friendly name. </summary>
        public string RecoveryFabricFriendlyName { get; }
        /// <summary> The failover deployment model. </summary>
        public string FailoverDeploymentModel { get; }
        /// <summary> The list of replication providers. </summary>
        public IReadOnlyList<string> ReplicationProviders { get; }
        /// <summary> The list of allowed operations. </summary>
        public IReadOnlyList<string> AllowedOperations { get; }
        /// <summary> The start time of the last planned failover. </summary>
        public DateTimeOffset? LastPlannedFailoverOn { get; }
        /// <summary> The start time of the last unplanned failover. </summary>
        public DateTimeOffset? LastUnplannedFailoverOn { get; }
        /// <summary> The start time of the last test failover. </summary>
        public DateTimeOffset? LastTestFailoverOn { get; }
        /// <summary> The current scenario details. </summary>
        public CurrentScenarioDetails CurrentScenario { get; }
        /// <summary> The recovery plan status. </summary>
        public string CurrentScenarioStatus { get; }
        /// <summary> The recovery plan status description. </summary>
        public string CurrentScenarioStatusDescription { get; }
        /// <summary> The recovery plan groups. </summary>
        public IReadOnlyList<SiteRecoveryPlanGroup> Groups { get; }
        /// <summary>
        /// The provider id and provider specific details.
        /// Please note <see cref="RecoveryPlanProviderSpecificDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RecoveryPlanA2ADetails"/>.
        /// </summary>
        public IReadOnlyList<RecoveryPlanProviderSpecificDetails> ProviderSpecificDetails { get; }
    }
}
