// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The health. </summary>
    public readonly partial struct SiteRecoveryProtectionHealth : IEquatable<SiteRecoveryProtectionHealth>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryProtectionHealth"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SiteRecoveryProtectionHealth(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string NormalValue = "Normal";
        private const string WarningValue = "Warning";
        private const string CriticalValue = "Critical";

        /// <summary> None. </summary>
        public static SiteRecoveryProtectionHealth None { get; } = new SiteRecoveryProtectionHealth(NoneValue);
        /// <summary> Normal. </summary>
        public static SiteRecoveryProtectionHealth Normal { get; } = new SiteRecoveryProtectionHealth(NormalValue);
        /// <summary> Warning. </summary>
        public static SiteRecoveryProtectionHealth Warning { get; } = new SiteRecoveryProtectionHealth(WarningValue);
        /// <summary> Critical. </summary>
        public static SiteRecoveryProtectionHealth Critical { get; } = new SiteRecoveryProtectionHealth(CriticalValue);
        /// <summary> Determines if two <see cref="SiteRecoveryProtectionHealth"/> values are the same. </summary>
        public static bool operator ==(SiteRecoveryProtectionHealth left, SiteRecoveryProtectionHealth right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SiteRecoveryProtectionHealth"/> values are not the same. </summary>
        public static bool operator !=(SiteRecoveryProtectionHealth left, SiteRecoveryProtectionHealth right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SiteRecoveryProtectionHealth"/>. </summary>
        public static implicit operator SiteRecoveryProtectionHealth(string value) => new SiteRecoveryProtectionHealth(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SiteRecoveryProtectionHealth other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SiteRecoveryProtectionHealth other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
