// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Net;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    public partial class SiteRecoveryProcessServerDetails : IUtf8JsonSerializable, IJsonModel<SiteRecoveryProcessServerDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SiteRecoveryProcessServerDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SiteRecoveryProcessServerDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoveryProcessServerDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SiteRecoveryProcessServerDetails)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Id))
            {
                writer.WritePropertyName("id"u8);
                writer.WriteStringValue(Id);
            }
            if (options.Format != "W" && Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (options.Format != "W" && Optional.IsDefined(BiosId))
            {
                writer.WritePropertyName("biosId"u8);
                writer.WriteStringValue(BiosId);
            }
            if (options.Format != "W" && Optional.IsDefined(FabricObjectId))
            {
                writer.WritePropertyName("fabricObjectId"u8);
                writer.WriteStringValue(FabricObjectId);
            }
            if (options.Format != "W" && Optional.IsDefined(Fqdn))
            {
                writer.WritePropertyName("fqdn"u8);
                writer.WriteStringValue(Fqdn);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(IPAddresses))
            {
                writer.WritePropertyName("ipAddresses"u8);
                writer.WriteStartArray();
                foreach (var item in IPAddresses)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(Version))
            {
                writer.WritePropertyName("version"u8);
                writer.WriteStringValue(Version);
            }
            if (options.Format != "W" && Optional.IsDefined(LastHeartbeatReceivedOn))
            {
                writer.WritePropertyName("lastHeartbeatUtc"u8);
                writer.WriteStringValue(LastHeartbeatReceivedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(TotalMemoryInBytes))
            {
                writer.WritePropertyName("totalMemoryInBytes"u8);
                writer.WriteNumberValue(TotalMemoryInBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AvailableMemoryInBytes))
            {
                writer.WritePropertyName("availableMemoryInBytes"u8);
                writer.WriteNumberValue(AvailableMemoryInBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UsedMemoryInBytes))
            {
                writer.WritePropertyName("usedMemoryInBytes"u8);
                writer.WriteNumberValue(UsedMemoryInBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MemoryUsagePercentage))
            {
                writer.WritePropertyName("memoryUsagePercentage"u8);
                writer.WriteNumberValue(MemoryUsagePercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalSpaceInBytes))
            {
                writer.WritePropertyName("totalSpaceInBytes"u8);
                writer.WriteNumberValue(TotalSpaceInBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AvailableSpaceInBytes))
            {
                writer.WritePropertyName("availableSpaceInBytes"u8);
                writer.WriteNumberValue(AvailableSpaceInBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UsedSpaceInBytes))
            {
                writer.WritePropertyName("usedSpaceInBytes"u8);
                writer.WriteNumberValue(UsedSpaceInBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(FreeSpacePercentage))
            {
                writer.WritePropertyName("freeSpacePercentage"u8);
                writer.WriteNumberValue(FreeSpacePercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ThroughputUploadPendingDataInBytes))
            {
                writer.WritePropertyName("throughputUploadPendingDataInBytes"u8);
                writer.WriteNumberValue(ThroughputUploadPendingDataInBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ThroughputInBytes))
            {
                writer.WritePropertyName("throughputInBytes"u8);
                writer.WriteNumberValue(ThroughputInBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ProcessorUsagePercentage))
            {
                writer.WritePropertyName("processorUsagePercentage"u8);
                writer.WriteNumberValue(ProcessorUsagePercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ThroughputStatus))
            {
                writer.WritePropertyName("throughputStatus"u8);
                writer.WriteStringValue(ThroughputStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(SystemLoad))
            {
                writer.WritePropertyName("systemLoad"u8);
                writer.WriteNumberValue(SystemLoad.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SystemLoadStatus))
            {
                writer.WritePropertyName("systemLoadStatus"u8);
                writer.WriteStringValue(SystemLoadStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(DiskUsageStatus))
            {
                writer.WritePropertyName("diskUsageStatus"u8);
                writer.WriteStringValue(DiskUsageStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(MemoryUsageStatus))
            {
                writer.WritePropertyName("memoryUsageStatus"u8);
                writer.WriteStringValue(MemoryUsageStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ProcessorUsageStatus))
            {
                writer.WritePropertyName("processorUsageStatus"u8);
                writer.WriteStringValue(ProcessorUsageStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(Health))
            {
                writer.WritePropertyName("health"u8);
                writer.WriteStringValue(Health.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(HealthErrors))
            {
                writer.WritePropertyName("healthErrors"u8);
                writer.WriteStartArray();
                foreach (var item in HealthErrors)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ProtectedItemCount))
            {
                writer.WritePropertyName("protectedItemCount"u8);
                writer.WriteNumberValue(ProtectedItemCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(HistoricHealth))
            {
                writer.WritePropertyName("historicHealth"u8);
                writer.WriteStringValue(HistoricHealth.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SiteRecoveryProcessServerDetails IJsonModel<SiteRecoveryProcessServerDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoveryProcessServerDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SiteRecoveryProcessServerDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSiteRecoveryProcessServerDetails(document.RootElement, options);
        }

        internal static SiteRecoveryProcessServerDetails DeserializeSiteRecoveryProcessServerDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            string name = default;
            string biosId = default;
            ResourceIdentifier fabricObjectId = default;
            string fqdn = default;
            IReadOnlyList<IPAddress> ipAddresses = default;
            string version = default;
            DateTimeOffset? lastHeartbeatUtc = default;
            long? totalMemoryInBytes = default;
            long? availableMemoryInBytes = default;
            long? usedMemoryInBytes = default;
            double? memoryUsagePercentage = default;
            long? totalSpaceInBytes = default;
            long? availableSpaceInBytes = default;
            long? usedSpaceInBytes = default;
            double? freeSpacePercentage = default;
            long? throughputUploadPendingDataInBytes = default;
            long? throughputInBytes = default;
            double? processorUsagePercentage = default;
            RcmComponentStatus? throughputStatus = default;
            long? systemLoad = default;
            RcmComponentStatus? systemLoadStatus = default;
            RcmComponentStatus? diskUsageStatus = default;
            RcmComponentStatus? memoryUsageStatus = default;
            RcmComponentStatus? processorUsageStatus = default;
            SiteRecoveryProtectionHealth? health = default;
            IReadOnlyList<SiteRecoveryHealthError> healthErrors = default;
            int? protectedItemCount = default;
            SiteRecoveryProtectionHealth? historicHealth = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("biosId"u8))
                {
                    biosId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fabricObjectId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fabricObjectId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("fqdn"u8))
                {
                    fqdn = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ipAddresses"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<IPAddress> array = new List<IPAddress>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        if (item.ValueKind == JsonValueKind.Null)
                        {
                            array.Add(null);
                        }
                        else
                        {
                            array.Add(IPAddress.Parse(item.GetString()));
                        }
                    }
                    ipAddresses = array;
                    continue;
                }
                if (property.NameEquals("version"u8))
                {
                    version = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastHeartbeatUtc"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastHeartbeatUtc = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("totalMemoryInBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalMemoryInBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("availableMemoryInBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    availableMemoryInBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("usedMemoryInBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    usedMemoryInBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("memoryUsagePercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    memoryUsagePercentage = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("totalSpaceInBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalSpaceInBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("availableSpaceInBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    availableSpaceInBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("usedSpaceInBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    usedSpaceInBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("freeSpacePercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    freeSpacePercentage = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("throughputUploadPendingDataInBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    throughputUploadPendingDataInBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("throughputInBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    throughputInBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("processorUsagePercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    processorUsagePercentage = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("throughputStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    throughputStatus = new RcmComponentStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemLoad"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemLoad = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("systemLoadStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemLoadStatus = new RcmComponentStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("diskUsageStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    diskUsageStatus = new RcmComponentStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("memoryUsageStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    memoryUsageStatus = new RcmComponentStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("processorUsageStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    processorUsageStatus = new RcmComponentStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("health"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    health = new SiteRecoveryProtectionHealth(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("healthErrors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SiteRecoveryHealthError> array = new List<SiteRecoveryHealthError>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SiteRecoveryHealthError.DeserializeSiteRecoveryHealthError(item, options));
                    }
                    healthErrors = array;
                    continue;
                }
                if (property.NameEquals("protectedItemCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    protectedItemCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("historicHealth"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    historicHealth = new SiteRecoveryProtectionHealth(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SiteRecoveryProcessServerDetails(
                id,
                name,
                biosId,
                fabricObjectId,
                fqdn,
                ipAddresses ?? new ChangeTrackingList<IPAddress>(),
                version,
                lastHeartbeatUtc,
                totalMemoryInBytes,
                availableMemoryInBytes,
                usedMemoryInBytes,
                memoryUsagePercentage,
                totalSpaceInBytes,
                availableSpaceInBytes,
                usedSpaceInBytes,
                freeSpacePercentage,
                throughputUploadPendingDataInBytes,
                throughputInBytes,
                processorUsagePercentage,
                throughputStatus,
                systemLoad,
                systemLoadStatus,
                diskUsageStatus,
                memoryUsageStatus,
                processorUsageStatus,
                health,
                healthErrors ?? new ChangeTrackingList<SiteRecoveryHealthError>(),
                protectedItemCount,
                historicHealth,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SiteRecoveryProcessServerDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoveryProcessServerDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SiteRecoveryProcessServerDetails)} does not support writing '{options.Format}' format.");
            }
        }

        SiteRecoveryProcessServerDetails IPersistableModel<SiteRecoveryProcessServerDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoveryProcessServerDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSiteRecoveryProcessServerDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SiteRecoveryProcessServerDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SiteRecoveryProcessServerDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
