// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The recovery point type. Values from LatestTime, LatestTag or Custom. In the case of custom, the recovery point provided by RecoveryPointId will be used. In the other two cases, recovery point id will be ignored. </summary>
    public readonly partial struct SiteRecoveryPointType : IEquatable<SiteRecoveryPointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryPointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SiteRecoveryPointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LatestTimeValue = "LatestTime";
        private const string LatestTagValue = "LatestTag";
        private const string CustomValue = "Custom";

        /// <summary> LatestTime. </summary>
        public static SiteRecoveryPointType LatestTime { get; } = new SiteRecoveryPointType(LatestTimeValue);
        /// <summary> LatestTag. </summary>
        public static SiteRecoveryPointType LatestTag { get; } = new SiteRecoveryPointType(LatestTagValue);
        /// <summary> Custom. </summary>
        public static SiteRecoveryPointType Custom { get; } = new SiteRecoveryPointType(CustomValue);
        /// <summary> Determines if two <see cref="SiteRecoveryPointType"/> values are the same. </summary>
        public static bool operator ==(SiteRecoveryPointType left, SiteRecoveryPointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SiteRecoveryPointType"/> values are not the same. </summary>
        public static bool operator !=(SiteRecoveryPointType left, SiteRecoveryPointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SiteRecoveryPointType"/>. </summary>
        public static implicit operator SiteRecoveryPointType(string value) => new SiteRecoveryPointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SiteRecoveryPointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SiteRecoveryPointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
