// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Recovery point properties. </summary>
    public partial class SiteRecoveryPointProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryPointProperties"/>. </summary>
        internal SiteRecoveryPointProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryPointProperties"/>. </summary>
        /// <param name="recoveryPointOn"> The recovery point time. </param>
        /// <param name="recoveryPointType"> The recovery point type: ApplicationConsistent, CrashConsistent. </param>
        /// <param name="providerSpecificDetails">
        /// The provider specific details for the recovery point.
        /// Please note <see cref="ProviderSpecificRecoveryPointDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="A2ARecoveryPointDetails"/>, <see cref="InMageAzureV2RecoveryPointDetails"/> and <see cref="InMageRcmRecoveryPointDetails"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoveryPointProperties(DateTimeOffset? recoveryPointOn, string recoveryPointType, ProviderSpecificRecoveryPointDetails providerSpecificDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RecoveryPointOn = recoveryPointOn;
            RecoveryPointType = recoveryPointType;
            ProviderSpecificDetails = providerSpecificDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The recovery point time. </summary>
        public DateTimeOffset? RecoveryPointOn { get; }
        /// <summary> The recovery point type: ApplicationConsistent, CrashConsistent. </summary>
        public string RecoveryPointType { get; }
        /// <summary>
        /// The provider specific details for the recovery point.
        /// Please note <see cref="ProviderSpecificRecoveryPointDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="A2ARecoveryPointDetails"/>, <see cref="InMageAzureV2RecoveryPointDetails"/> and <see cref="InMageRcmRecoveryPointDetails"/>.
        /// </summary>
        public ProviderSpecificRecoveryPointDetails ProviderSpecificDetails { get; }
    }
}
