// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Recovery plan group details. </summary>
    public partial class SiteRecoveryPlanGroup
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryPlanGroup"/>. </summary>
        /// <param name="groupType"> The group type. </param>
        public SiteRecoveryPlanGroup(RecoveryPlanGroupType groupType)
        {
            GroupType = groupType;
            ReplicationProtectedItems = new ChangeTrackingList<RecoveryPlanProtectedItem>();
            StartGroupActions = new ChangeTrackingList<RecoveryPlanAction>();
            EndGroupActions = new ChangeTrackingList<RecoveryPlanAction>();
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryPlanGroup"/>. </summary>
        /// <param name="groupType"> The group type. </param>
        /// <param name="replicationProtectedItems"> The list of protected items. </param>
        /// <param name="startGroupActions"> The start group actions. </param>
        /// <param name="endGroupActions"> The end group actions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoveryPlanGroup(RecoveryPlanGroupType groupType, IList<RecoveryPlanProtectedItem> replicationProtectedItems, IList<RecoveryPlanAction> startGroupActions, IList<RecoveryPlanAction> endGroupActions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            GroupType = groupType;
            ReplicationProtectedItems = replicationProtectedItems;
            StartGroupActions = startGroupActions;
            EndGroupActions = endGroupActions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryPlanGroup"/> for deserialization. </summary>
        internal SiteRecoveryPlanGroup()
        {
        }

        /// <summary> The group type. </summary>
        public RecoveryPlanGroupType GroupType { get; set; }
        /// <summary> The list of protected items. </summary>
        public IList<RecoveryPlanProtectedItem> ReplicationProtectedItems { get; }
        /// <summary> The start group actions. </summary>
        public IList<RecoveryPlanAction> StartGroupActions { get; }
        /// <summary> The end group actions. </summary>
        public IList<RecoveryPlanAction> EndGroupActions { get; }
    }
}
