// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Migration item properties. </summary>
    public partial class SiteRecoveryMigrationItemProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryMigrationItemProperties"/>. </summary>
        internal SiteRecoveryMigrationItemProperties()
        {
            HealthErrors = new ChangeTrackingList<SiteRecoveryHealthError>();
            AllowedOperations = new ChangeTrackingList<MigrationItemOperation>();
            CriticalJobHistory = new ChangeTrackingList<CriticalJobHistoryDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryMigrationItemProperties"/>. </summary>
        /// <param name="machineName"> The on-premise virtual machine name. </param>
        /// <param name="policyId"> The ARM Id of policy governing this item. </param>
        /// <param name="policyFriendlyName"> The name of policy governing this item. </param>
        /// <param name="recoveryServicesProviderId"> The recovery services provider ARM Id. </param>
        /// <param name="replicationStatus"> The replication status. </param>
        /// <param name="migrationState"> The migration status. </param>
        /// <param name="migrationStateDescription"> The migration state description. </param>
        /// <param name="lastTestMigrationOn"> The last test migration time. </param>
        /// <param name="lastTestMigrationStatus"> The status of the last test migration. </param>
        /// <param name="lastMigrationOn"> The last migration time. </param>
        /// <param name="lastMigrationStatus"> The status of the last migration. </param>
        /// <param name="testMigrateState"> The test migrate state. </param>
        /// <param name="testMigrateStateDescription"> The test migrate state description. </param>
        /// <param name="health"> The consolidated health. </param>
        /// <param name="healthErrors"> The list of health errors. </param>
        /// <param name="allowedOperations"> The allowed operations on the migration item based on the current migration state of the item. </param>
        /// <param name="currentJob"> The current job details. </param>
        /// <param name="criticalJobHistory"> The critical past job details. </param>
        /// <param name="eventCorrelationId"> The correlation Id for events associated with this migration item. </param>
        /// <param name="providerSpecificDetails">
        /// The migration provider custom settings.
        /// Please note <see cref="MigrationProviderSpecificSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="VMwareCbtMigrationDetails"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoveryMigrationItemProperties(string machineName, ResourceIdentifier policyId, string policyFriendlyName, string recoveryServicesProviderId, string replicationStatus, SiteRecoveryMigrationState? migrationState, string migrationStateDescription, DateTimeOffset? lastTestMigrationOn, string lastTestMigrationStatus, DateTimeOffset? lastMigrationOn, string lastMigrationStatus, TestMigrationState? testMigrateState, string testMigrateStateDescription, SiteRecoveryProtectionHealth? health, IReadOnlyList<SiteRecoveryHealthError> healthErrors, IReadOnlyList<MigrationItemOperation> allowedOperations, CurrentJobDetails currentJob, IReadOnlyList<CriticalJobHistoryDetails> criticalJobHistory, string eventCorrelationId, MigrationProviderSpecificSettings providerSpecificDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MachineName = machineName;
            PolicyId = policyId;
            PolicyFriendlyName = policyFriendlyName;
            RecoveryServicesProviderId = recoveryServicesProviderId;
            ReplicationStatus = replicationStatus;
            MigrationState = migrationState;
            MigrationStateDescription = migrationStateDescription;
            LastTestMigrationOn = lastTestMigrationOn;
            LastTestMigrationStatus = lastTestMigrationStatus;
            LastMigrationOn = lastMigrationOn;
            LastMigrationStatus = lastMigrationStatus;
            TestMigrateState = testMigrateState;
            TestMigrateStateDescription = testMigrateStateDescription;
            Health = health;
            HealthErrors = healthErrors;
            AllowedOperations = allowedOperations;
            CurrentJob = currentJob;
            CriticalJobHistory = criticalJobHistory;
            EventCorrelationId = eventCorrelationId;
            ProviderSpecificDetails = providerSpecificDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The on-premise virtual machine name. </summary>
        public string MachineName { get; }
        /// <summary> The ARM Id of policy governing this item. </summary>
        public ResourceIdentifier PolicyId { get; }
        /// <summary> The name of policy governing this item. </summary>
        public string PolicyFriendlyName { get; }
        /// <summary> The recovery services provider ARM Id. </summary>
        public string RecoveryServicesProviderId { get; }
        /// <summary> The replication status. </summary>
        public string ReplicationStatus { get; }
        /// <summary> The migration status. </summary>
        public SiteRecoveryMigrationState? MigrationState { get; }
        /// <summary> The migration state description. </summary>
        public string MigrationStateDescription { get; }
        /// <summary> The last test migration time. </summary>
        public DateTimeOffset? LastTestMigrationOn { get; }
        /// <summary> The status of the last test migration. </summary>
        public string LastTestMigrationStatus { get; }
        /// <summary> The last migration time. </summary>
        public DateTimeOffset? LastMigrationOn { get; }
        /// <summary> The status of the last migration. </summary>
        public string LastMigrationStatus { get; }
        /// <summary> The test migrate state. </summary>
        public TestMigrationState? TestMigrateState { get; }
        /// <summary> The test migrate state description. </summary>
        public string TestMigrateStateDescription { get; }
        /// <summary> The consolidated health. </summary>
        public SiteRecoveryProtectionHealth? Health { get; }
        /// <summary> The list of health errors. </summary>
        public IReadOnlyList<SiteRecoveryHealthError> HealthErrors { get; }
        /// <summary> The allowed operations on the migration item based on the current migration state of the item. </summary>
        public IReadOnlyList<MigrationItemOperation> AllowedOperations { get; }
        /// <summary> The current job details. </summary>
        public CurrentJobDetails CurrentJob { get; }
        /// <summary> The critical past job details. </summary>
        public IReadOnlyList<CriticalJobHistoryDetails> CriticalJobHistory { get; }
        /// <summary> The correlation Id for events associated with this migration item. </summary>
        public string EventCorrelationId { get; }
        /// <summary>
        /// The migration provider custom settings.
        /// Please note <see cref="MigrationProviderSpecificSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="VMwareCbtMigrationDetails"/>.
        /// </summary>
        public MigrationProviderSpecificSettings ProviderSpecificDetails { get; }
    }
}
