// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary>
    /// This class represents a task which is actually a workflow so that one can navigate to its individual drill down.
    /// Please note <see cref="SiteRecoveryJobTaskDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="FabricReplicationGroupTaskDetails"/> and <see cref="SiteRecoveryVmTaskDetails"/>.
    /// </summary>
    public partial class SiteRecoveryJobTaskDetails : SiteRecoveryTaskTypeDetails
    {
        /// <summary> Initializes a new instance of <see cref="SiteRecoveryJobTaskDetails"/>. </summary>
        internal SiteRecoveryJobTaskDetails()
        {
            InstanceType = "JobTaskDetails";
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryJobTaskDetails"/>. </summary>
        /// <param name="instanceType"> The type of task details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="jobTask"> The job entity. </param>
        internal SiteRecoveryJobTaskDetails(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, SiteRecoveryJobEntity jobTask) : base(instanceType, serializedAdditionalRawData)
        {
            JobTask = jobTask;
            InstanceType = instanceType ?? "JobTaskDetails";
        }

        /// <summary> The job entity. </summary>
        public SiteRecoveryJobEntity JobTask { get; }
    }
}
