// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> This class contains the error details per object. </summary>
    public partial class SiteRecoveryJobProviderError
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryJobProviderError"/>. </summary>
        internal SiteRecoveryJobProviderError()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryJobProviderError"/>. </summary>
        /// <param name="errorCode"> The Error code. </param>
        /// <param name="errorMessage"> The Error message. </param>
        /// <param name="errorId"> The Provider error Id. </param>
        /// <param name="possibleCauses"> The possible causes for the error. </param>
        /// <param name="recommendedAction"> The recommended action to resolve the error. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoveryJobProviderError(int? errorCode, string errorMessage, string errorId, string possibleCauses, string recommendedAction, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ErrorCode = errorCode;
            ErrorMessage = errorMessage;
            ErrorId = errorId;
            PossibleCauses = possibleCauses;
            RecommendedAction = recommendedAction;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Error code. </summary>
        public int? ErrorCode { get; }
        /// <summary> The Error message. </summary>
        public string ErrorMessage { get; }
        /// <summary> The Provider error Id. </summary>
        public string ErrorId { get; }
        /// <summary> The possible causes for the error. </summary>
        public string PossibleCauses { get; }
        /// <summary> The recommended action to resolve the error. </summary>
        public string RecommendedAction { get; }
    }
}
