// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Job custom data details. </summary>
    public partial class SiteRecoveryJobProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryJobProperties"/>. </summary>
        internal SiteRecoveryJobProperties()
        {
            Tasks = new ChangeTrackingList<AsrTask>();
            Errors = new ChangeTrackingList<SiteRecoveryJobErrorDetails>();
            AllowedActions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryJobProperties"/>. </summary>
        /// <param name="activityId"> The activity id. </param>
        /// <param name="scenarioName"> The ScenarioName. </param>
        /// <param name="friendlyName"> The DisplayName. </param>
        /// <param name="state"> The status of the Job. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other. </param>
        /// <param name="stateDescription"> The description of the state of the Job. For e.g. - For Succeeded state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped. </param>
        /// <param name="tasks"> The tasks. </param>
        /// <param name="errors"> The errors. </param>
        /// <param name="startOn"> The start time. </param>
        /// <param name="endOn"> The end time. </param>
        /// <param name="allowedActions"> The Allowed action the job. </param>
        /// <param name="targetObjectId"> The affected Object Id. </param>
        /// <param name="targetObjectName"> The name of the affected object. </param>
        /// <param name="targetInstanceType"> The type of the affected object which is of Microsoft.Azure.SiteRecovery.V2015_11_10.AffectedObjectType class. </param>
        /// <param name="customDetails">
        /// The custom job details like test failover job details.
        /// Please note <see cref="SiteRecoveryJobDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AsrJobDetails"/>, <see cref="ExportJobDetails"/>, <see cref="FailoverJobDetails"/>, <see cref="SwitchProtectionJobDetails"/> and <see cref="TestFailoverJobDetails"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoveryJobProperties(string activityId, string scenarioName, string friendlyName, string state, string stateDescription, IReadOnlyList<AsrTask> tasks, IReadOnlyList<SiteRecoveryJobErrorDetails> errors, DateTimeOffset? startOn, DateTimeOffset? endOn, IReadOnlyList<string> allowedActions, string targetObjectId, string targetObjectName, string targetInstanceType, SiteRecoveryJobDetails customDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ActivityId = activityId;
            ScenarioName = scenarioName;
            FriendlyName = friendlyName;
            State = state;
            StateDescription = stateDescription;
            Tasks = tasks;
            Errors = errors;
            StartOn = startOn;
            EndOn = endOn;
            AllowedActions = allowedActions;
            TargetObjectId = targetObjectId;
            TargetObjectName = targetObjectName;
            TargetInstanceType = targetInstanceType;
            CustomDetails = customDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The activity id. </summary>
        public string ActivityId { get; }
        /// <summary> The ScenarioName. </summary>
        public string ScenarioName { get; }
        /// <summary> The DisplayName. </summary>
        public string FriendlyName { get; }
        /// <summary> The status of the Job. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other. </summary>
        public string State { get; }
        /// <summary> The description of the state of the Job. For e.g. - For Succeeded state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped. </summary>
        public string StateDescription { get; }
        /// <summary> The tasks. </summary>
        public IReadOnlyList<AsrTask> Tasks { get; }
        /// <summary> The errors. </summary>
        public IReadOnlyList<SiteRecoveryJobErrorDetails> Errors { get; }
        /// <summary> The start time. </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> The end time. </summary>
        public DateTimeOffset? EndOn { get; }
        /// <summary> The Allowed action the job. </summary>
        public IReadOnlyList<string> AllowedActions { get; }
        /// <summary> The affected Object Id. </summary>
        public string TargetObjectId { get; }
        /// <summary> The name of the affected object. </summary>
        public string TargetObjectName { get; }
        /// <summary> The type of the affected object which is of Microsoft.Azure.SiteRecovery.V2015_11_10.AffectedObjectType class. </summary>
        public string TargetInstanceType { get; }
        /// <summary>
        /// The custom job details like test failover job details.
        /// Please note <see cref="SiteRecoveryJobDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AsrJobDetails"/>, <see cref="ExportJobDetails"/>, <see cref="FailoverJobDetails"/>, <see cref="SwitchProtectionJobDetails"/> and <see cref="TestFailoverJobDetails"/>.
        /// </summary>
        public SiteRecoveryJobDetails CustomDetails { get; }
    }
}
