// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> This class contains the error details per object. </summary>
    public partial class SiteRecoveryJobErrorDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryJobErrorDetails"/>. </summary>
        internal SiteRecoveryJobErrorDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryJobErrorDetails"/>. </summary>
        /// <param name="serviceErrorDetails"> The Service error details. </param>
        /// <param name="providerErrorDetails"> The Provider error details. </param>
        /// <param name="errorLevel"> Error level of error. </param>
        /// <param name="createdOn"> The creation time of job error. </param>
        /// <param name="taskId"> The Id of the task. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoveryJobErrorDetails(SiteRecoveryServiceError serviceErrorDetails, SiteRecoveryJobProviderError providerErrorDetails, string errorLevel, DateTimeOffset? createdOn, string taskId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ServiceErrorDetails = serviceErrorDetails;
            ProviderErrorDetails = providerErrorDetails;
            ErrorLevel = errorLevel;
            CreatedOn = createdOn;
            TaskId = taskId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Service error details. </summary>
        public SiteRecoveryServiceError ServiceErrorDetails { get; }
        /// <summary> The Provider error details. </summary>
        public SiteRecoveryJobProviderError ProviderErrorDetails { get; }
        /// <summary> Error level of error. </summary>
        public string ErrorLevel { get; }
        /// <summary> The creation time of job error. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The Id of the task. </summary>
        public string TaskId { get; }
    }
}
