// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The source IP address type. </summary>
    public readonly partial struct SiteRecoveryEthernetAddressType : IEquatable<SiteRecoveryEthernetAddressType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryEthernetAddressType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SiteRecoveryEthernetAddressType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DynamicValue = "Dynamic";
        private const string StaticValue = "Static";

        /// <summary> Dynamic. </summary>
        public static SiteRecoveryEthernetAddressType Dynamic { get; } = new SiteRecoveryEthernetAddressType(DynamicValue);
        /// <summary> Static. </summary>
        public static SiteRecoveryEthernetAddressType Static { get; } = new SiteRecoveryEthernetAddressType(StaticValue);
        /// <summary> Determines if two <see cref="SiteRecoveryEthernetAddressType"/> values are the same. </summary>
        public static bool operator ==(SiteRecoveryEthernetAddressType left, SiteRecoveryEthernetAddressType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SiteRecoveryEthernetAddressType"/> values are not the same. </summary>
        public static bool operator !=(SiteRecoveryEthernetAddressType left, SiteRecoveryEthernetAddressType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SiteRecoveryEthernetAddressType"/>. </summary>
        public static implicit operator SiteRecoveryEthernetAddressType(string value) => new SiteRecoveryEthernetAddressType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SiteRecoveryEthernetAddressType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SiteRecoveryEthernetAddressType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
