// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Severity of error. </summary>
    public readonly partial struct SiteRecoveryErrorSeverity : IEquatable<SiteRecoveryErrorSeverity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryErrorSeverity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SiteRecoveryErrorSeverity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "NONE";
        private const string WarningValue = "Warning";
        private const string ErrorValue = "Error";
        private const string InfoValue = "Info";

        /// <summary> NONE. </summary>
        public static SiteRecoveryErrorSeverity None { get; } = new SiteRecoveryErrorSeverity(NoneValue);
        /// <summary> Warning. </summary>
        public static SiteRecoveryErrorSeverity Warning { get; } = new SiteRecoveryErrorSeverity(WarningValue);
        /// <summary> Error. </summary>
        public static SiteRecoveryErrorSeverity Error { get; } = new SiteRecoveryErrorSeverity(ErrorValue);
        /// <summary> Info. </summary>
        public static SiteRecoveryErrorSeverity Info { get; } = new SiteRecoveryErrorSeverity(InfoValue);
        /// <summary> Determines if two <see cref="SiteRecoveryErrorSeverity"/> values are the same. </summary>
        public static bool operator ==(SiteRecoveryErrorSeverity left, SiteRecoveryErrorSeverity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SiteRecoveryErrorSeverity"/> values are not the same. </summary>
        public static bool operator !=(SiteRecoveryErrorSeverity left, SiteRecoveryErrorSeverity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SiteRecoveryErrorSeverity"/>. </summary>
        public static implicit operator SiteRecoveryErrorSeverity(string value) => new SiteRecoveryErrorSeverity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SiteRecoveryErrorSeverity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SiteRecoveryErrorSeverity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
