// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The progress health. </summary>
    public readonly partial struct SiteRecoveryDiskReplicationProgressHealth : IEquatable<SiteRecoveryDiskReplicationProgressHealth>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryDiskReplicationProgressHealth"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SiteRecoveryDiskReplicationProgressHealth(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string InProgressValue = "InProgress";
        private const string SlowProgressValue = "SlowProgress";
        private const string NoProgressValue = "NoProgress";
        private const string QueuedValue = "Queued";

        /// <summary> None. </summary>
        public static SiteRecoveryDiskReplicationProgressHealth None { get; } = new SiteRecoveryDiskReplicationProgressHealth(NoneValue);
        /// <summary> InProgress. </summary>
        public static SiteRecoveryDiskReplicationProgressHealth InProgress { get; } = new SiteRecoveryDiskReplicationProgressHealth(InProgressValue);
        /// <summary> SlowProgress. </summary>
        public static SiteRecoveryDiskReplicationProgressHealth SlowProgress { get; } = new SiteRecoveryDiskReplicationProgressHealth(SlowProgressValue);
        /// <summary> NoProgress. </summary>
        public static SiteRecoveryDiskReplicationProgressHealth NoProgress { get; } = new SiteRecoveryDiskReplicationProgressHealth(NoProgressValue);
        /// <summary> Queued. </summary>
        public static SiteRecoveryDiskReplicationProgressHealth Queued { get; } = new SiteRecoveryDiskReplicationProgressHealth(QueuedValue);
        /// <summary> Determines if two <see cref="SiteRecoveryDiskReplicationProgressHealth"/> values are the same. </summary>
        public static bool operator ==(SiteRecoveryDiskReplicationProgressHealth left, SiteRecoveryDiskReplicationProgressHealth right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SiteRecoveryDiskReplicationProgressHealth"/> values are not the same. </summary>
        public static bool operator !=(SiteRecoveryDiskReplicationProgressHealth left, SiteRecoveryDiskReplicationProgressHealth right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SiteRecoveryDiskReplicationProgressHealth"/>. </summary>
        public static implicit operator SiteRecoveryDiskReplicationProgressHealth(string value) => new SiteRecoveryDiskReplicationProgressHealth(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SiteRecoveryDiskReplicationProgressHealth other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SiteRecoveryDiskReplicationProgressHealth other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
