// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Disk Encryption Key Information (BitLocker Encryption Key (BEK) on Windows). </summary>
    public partial class SiteRecoveryDiskEncryptionKeyInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryDiskEncryptionKeyInfo"/>. </summary>
        public SiteRecoveryDiskEncryptionKeyInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryDiskEncryptionKeyInfo"/>. </summary>
        /// <param name="secretIdentifier"> The secret url / identifier. </param>
        /// <param name="keyVaultResourceArmId"> The KeyVault resource ARM id for secret. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoveryDiskEncryptionKeyInfo(string secretIdentifier, ResourceIdentifier keyVaultResourceArmId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SecretIdentifier = secretIdentifier;
            KeyVaultResourceArmId = keyVaultResourceArmId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The secret url / identifier. </summary>
        public string SecretIdentifier { get; set; }
        /// <summary> The KeyVault resource ARM id for secret. </summary>
        public ResourceIdentifier KeyVaultResourceArmId { get; set; }
    }
}
