// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Onprem disk details data. </summary>
    public partial class SiteRecoveryDiskDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryDiskDetails"/>. </summary>
        internal SiteRecoveryDiskDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryDiskDetails"/>. </summary>
        /// <param name="maxSizeMB"> The hard disk max size in MB. </param>
        /// <param name="vhdType"> The type of the volume. </param>
        /// <param name="vhdId"> The VHD Id. </param>
        /// <param name="vhdName"> The VHD name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SiteRecoveryDiskDetails(long? maxSizeMB, string vhdType, string vhdId, string vhdName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MaxSizeMB = maxSizeMB;
            VhdType = vhdType;
            VhdId = vhdId;
            VhdName = vhdName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The hard disk max size in MB. </summary>
        public long? MaxSizeMB { get; }
        /// <summary> The type of the volume. </summary>
        public string VhdType { get; }
        /// <summary> The VHD Id. </summary>
        public string VhdId { get; }
        /// <summary> The VHD name. </summary>
        public string VhdName { get; }
    }
}
