// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The DiskType. </summary>
    public readonly partial struct SiteRecoveryDiskAccountType : IEquatable<SiteRecoveryDiskAccountType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryDiskAccountType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SiteRecoveryDiskAccountType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardLrsValue = "Standard_LRS";
        private const string PremiumLrsValue = "Premium_LRS";
        private const string StandardSsdLrsValue = "StandardSSD_LRS";

        /// <summary> Standard_LRS. </summary>
        public static SiteRecoveryDiskAccountType StandardLrs { get; } = new SiteRecoveryDiskAccountType(StandardLrsValue);
        /// <summary> Premium_LRS. </summary>
        public static SiteRecoveryDiskAccountType PremiumLrs { get; } = new SiteRecoveryDiskAccountType(PremiumLrsValue);
        /// <summary> StandardSSD_LRS. </summary>
        public static SiteRecoveryDiskAccountType StandardSsdLrs { get; } = new SiteRecoveryDiskAccountType(StandardSsdLrsValue);
        /// <summary> Determines if two <see cref="SiteRecoveryDiskAccountType"/> values are the same. </summary>
        public static bool operator ==(SiteRecoveryDiskAccountType left, SiteRecoveryDiskAccountType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SiteRecoveryDiskAccountType"/> values are not the same. </summary>
        public static bool operator !=(SiteRecoveryDiskAccountType left, SiteRecoveryDiskAccountType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SiteRecoveryDiskAccountType"/>. </summary>
        public static implicit operator SiteRecoveryDiskAccountType(string value) => new SiteRecoveryDiskAccountType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SiteRecoveryDiskAccountType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SiteRecoveryDiskAccountType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
