// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The data sync option. </summary>
    public readonly partial struct SiteRecoveryDataSyncStatus : IEquatable<SiteRecoveryDataSyncStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryDataSyncStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SiteRecoveryDataSyncStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ForDownTimeValue = "ForDownTime";
        private const string ForSynchronizationValue = "ForSynchronization";

        /// <summary> ForDownTime. </summary>
        public static SiteRecoveryDataSyncStatus ForDownTime { get; } = new SiteRecoveryDataSyncStatus(ForDownTimeValue);
        /// <summary> ForSynchronization. </summary>
        public static SiteRecoveryDataSyncStatus ForSynchronization { get; } = new SiteRecoveryDataSyncStatus(ForSynchronizationValue);
        /// <summary> Determines if two <see cref="SiteRecoveryDataSyncStatus"/> values are the same. </summary>
        public static bool operator ==(SiteRecoveryDataSyncStatus left, SiteRecoveryDataSyncStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SiteRecoveryDataSyncStatus"/> values are not the same. </summary>
        public static bool operator !=(SiteRecoveryDataSyncStatus left, SiteRecoveryDataSyncStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SiteRecoveryDataSyncStatus"/>. </summary>
        public static implicit operator SiteRecoveryDataSyncStatus(string value) => new SiteRecoveryDataSyncStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SiteRecoveryDataSyncStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SiteRecoveryDataSyncStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
