// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    public partial class SiteRecoveryCreateRecoveryPlanProperties : IUtf8JsonSerializable, IJsonModel<SiteRecoveryCreateRecoveryPlanProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SiteRecoveryCreateRecoveryPlanProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SiteRecoveryCreateRecoveryPlanProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoveryCreateRecoveryPlanProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SiteRecoveryCreateRecoveryPlanProperties)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("primaryFabricId"u8);
            writer.WriteStringValue(PrimaryFabricId);
            writer.WritePropertyName("recoveryFabricId"u8);
            writer.WriteStringValue(RecoveryFabricId);
            if (Optional.IsDefined(FailoverDeploymentModel))
            {
                writer.WritePropertyName("failoverDeploymentModel"u8);
                writer.WriteStringValue(FailoverDeploymentModel.Value.ToString());
            }
            writer.WritePropertyName("groups"u8);
            writer.WriteStartArray();
            foreach (var item in Groups)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (Optional.IsCollectionDefined(ProviderSpecificContent))
            {
                writer.WritePropertyName("providerSpecificInput"u8);
                writer.WriteStartArray();
                foreach (var item in ProviderSpecificContent)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SiteRecoveryCreateRecoveryPlanProperties IJsonModel<SiteRecoveryCreateRecoveryPlanProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoveryCreateRecoveryPlanProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SiteRecoveryCreateRecoveryPlanProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSiteRecoveryCreateRecoveryPlanProperties(document.RootElement, options);
        }

        internal static SiteRecoveryCreateRecoveryPlanProperties DeserializeSiteRecoveryCreateRecoveryPlanProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier primaryFabricId = default;
            ResourceIdentifier recoveryFabricId = default;
            FailoverDeploymentModel? failoverDeploymentModel = default;
            IList<SiteRecoveryPlanGroup> groups = default;
            IList<RecoveryPlanProviderSpecificContent> providerSpecificContent = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("primaryFabricId"u8))
                {
                    primaryFabricId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("recoveryFabricId"u8))
                {
                    recoveryFabricId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("failoverDeploymentModel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    failoverDeploymentModel = new FailoverDeploymentModel(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("groups"u8))
                {
                    List<SiteRecoveryPlanGroup> array = new List<SiteRecoveryPlanGroup>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SiteRecoveryPlanGroup.DeserializeSiteRecoveryPlanGroup(item, options));
                    }
                    groups = array;
                    continue;
                }
                if (property.NameEquals("providerSpecificInput"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RecoveryPlanProviderSpecificContent> array = new List<RecoveryPlanProviderSpecificContent>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(RecoveryPlanProviderSpecificContent.DeserializeRecoveryPlanProviderSpecificContent(item, options));
                    }
                    providerSpecificContent = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SiteRecoveryCreateRecoveryPlanProperties(
                primaryFabricId,
                recoveryFabricId,
                failoverDeploymentModel,
                groups,
                providerSpecificContent ?? new ChangeTrackingList<RecoveryPlanProviderSpecificContent>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SiteRecoveryCreateRecoveryPlanProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoveryCreateRecoveryPlanProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SiteRecoveryCreateRecoveryPlanProperties)} does not support writing '{options.Format}' format.");
            }
        }

        SiteRecoveryCreateRecoveryPlanProperties IPersistableModel<SiteRecoveryCreateRecoveryPlanProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoveryCreateRecoveryPlanProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSiteRecoveryCreateRecoveryPlanProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SiteRecoveryCreateRecoveryPlanProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SiteRecoveryCreateRecoveryPlanProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
