// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> A value indicating whether the auto update is enabled. </summary>
    public readonly partial struct SiteRecoveryAgentAutoUpdateStatus : IEquatable<SiteRecoveryAgentAutoUpdateStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SiteRecoveryAgentAutoUpdateStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SiteRecoveryAgentAutoUpdateStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static SiteRecoveryAgentAutoUpdateStatus Disabled { get; } = new SiteRecoveryAgentAutoUpdateStatus(DisabledValue);
        /// <summary> Enabled. </summary>
        public static SiteRecoveryAgentAutoUpdateStatus Enabled { get; } = new SiteRecoveryAgentAutoUpdateStatus(EnabledValue);
        /// <summary> Determines if two <see cref="SiteRecoveryAgentAutoUpdateStatus"/> values are the same. </summary>
        public static bool operator ==(SiteRecoveryAgentAutoUpdateStatus left, SiteRecoveryAgentAutoUpdateStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SiteRecoveryAgentAutoUpdateStatus"/> values are not the same. </summary>
        public static bool operator !=(SiteRecoveryAgentAutoUpdateStatus left, SiteRecoveryAgentAutoUpdateStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SiteRecoveryAgentAutoUpdateStatus"/>. </summary>
        public static implicit operator SiteRecoveryAgentAutoUpdateStatus(string value) => new SiteRecoveryAgentAutoUpdateStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SiteRecoveryAgentAutoUpdateStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SiteRecoveryAgentAutoUpdateStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
