// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    public partial class SiteRecoveryAddRecoveryServicesProviderProperties : IUtf8JsonSerializable, IJsonModel<SiteRecoveryAddRecoveryServicesProviderProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SiteRecoveryAddRecoveryServicesProviderProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SiteRecoveryAddRecoveryServicesProviderProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoveryAddRecoveryServicesProviderProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SiteRecoveryAddRecoveryServicesProviderProperties)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("machineName"u8);
            writer.WriteStringValue(MachineName);
            if (Optional.IsDefined(MachineId))
            {
                writer.WritePropertyName("machineId"u8);
                writer.WriteStringValue(MachineId);
            }
            if (Optional.IsDefined(BiosId))
            {
                writer.WritePropertyName("biosId"u8);
                writer.WriteStringValue(BiosId);
            }
            writer.WritePropertyName("authenticationIdentityInput"u8);
            writer.WriteObjectValue(AuthenticationIdentityContent, options);
            writer.WritePropertyName("resourceAccessIdentityInput"u8);
            writer.WriteObjectValue(ResourceAccessIdentityContent, options);
            if (Optional.IsDefined(DataPlaneAuthenticationIdentityContent))
            {
                writer.WritePropertyName("dataPlaneAuthenticationIdentityInput"u8);
                writer.WriteObjectValue(DataPlaneAuthenticationIdentityContent, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SiteRecoveryAddRecoveryServicesProviderProperties IJsonModel<SiteRecoveryAddRecoveryServicesProviderProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoveryAddRecoveryServicesProviderProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SiteRecoveryAddRecoveryServicesProviderProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSiteRecoveryAddRecoveryServicesProviderProperties(document.RootElement, options);
        }

        internal static SiteRecoveryAddRecoveryServicesProviderProperties DeserializeSiteRecoveryAddRecoveryServicesProviderProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string machineName = default;
            string machineId = default;
            string biosId = default;
            IdentityProviderContent authenticationIdentityContent = default;
            IdentityProviderContent resourceAccessIdentityContent = default;
            IdentityProviderContent dataPlaneAuthenticationIdentityContent = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("machineName"u8))
                {
                    machineName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("machineId"u8))
                {
                    machineId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("biosId"u8))
                {
                    biosId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("authenticationIdentityInput"u8))
                {
                    authenticationIdentityContent = IdentityProviderContent.DeserializeIdentityProviderContent(property.Value, options);
                    continue;
                }
                if (property.NameEquals("resourceAccessIdentityInput"u8))
                {
                    resourceAccessIdentityContent = IdentityProviderContent.DeserializeIdentityProviderContent(property.Value, options);
                    continue;
                }
                if (property.NameEquals("dataPlaneAuthenticationIdentityInput"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataPlaneAuthenticationIdentityContent = IdentityProviderContent.DeserializeIdentityProviderContent(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SiteRecoveryAddRecoveryServicesProviderProperties(
                machineName,
                machineId,
                biosId,
                authenticationIdentityContent,
                resourceAccessIdentityContent,
                dataPlaneAuthenticationIdentityContent,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SiteRecoveryAddRecoveryServicesProviderProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoveryAddRecoveryServicesProviderProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SiteRecoveryAddRecoveryServicesProviderProperties)} does not support writing '{options.Format}' format.");
            }
        }

        SiteRecoveryAddRecoveryServicesProviderProperties IPersistableModel<SiteRecoveryAddRecoveryServicesProviderProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SiteRecoveryAddRecoveryServicesProviderProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSiteRecoveryAddRecoveryServicesProviderProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SiteRecoveryAddRecoveryServicesProviderProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SiteRecoveryAddRecoveryServicesProviderProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
