// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. </summary>
    public readonly partial struct SetMultiVmSyncStatus : IEquatable<SetMultiVmSyncStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SetMultiVmSyncStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SetMultiVmSyncStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnableValue = "Enable";
        private const string DisableValue = "Disable";

        /// <summary> Enable. </summary>
        public static SetMultiVmSyncStatus Enable { get; } = new SetMultiVmSyncStatus(EnableValue);
        /// <summary> Disable. </summary>
        public static SetMultiVmSyncStatus Disable { get; } = new SetMultiVmSyncStatus(DisableValue);
        /// <summary> Determines if two <see cref="SetMultiVmSyncStatus"/> values are the same. </summary>
        public static bool operator ==(SetMultiVmSyncStatus left, SetMultiVmSyncStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SetMultiVmSyncStatus"/> values are not the same. </summary>
        public static bool operator !=(SetMultiVmSyncStatus left, SetMultiVmSyncStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SetMultiVmSyncStatus"/>. </summary>
        public static implicit operator SetMultiVmSyncStatus(string value) => new SetMultiVmSyncStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SetMultiVmSyncStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SetMultiVmSyncStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
