// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The recovery point type. </summary>
    public readonly partial struct RpInMageRecoveryPointType : IEquatable<RpInMageRecoveryPointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RpInMageRecoveryPointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RpInMageRecoveryPointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LatestTimeValue = "LatestTime";
        private const string LatestTagValue = "LatestTag";
        private const string CustomValue = "Custom";

        /// <summary> LatestTime. </summary>
        public static RpInMageRecoveryPointType LatestTime { get; } = new RpInMageRecoveryPointType(LatestTimeValue);
        /// <summary> LatestTag. </summary>
        public static RpInMageRecoveryPointType LatestTag { get; } = new RpInMageRecoveryPointType(LatestTagValue);
        /// <summary> Custom. </summary>
        public static RpInMageRecoveryPointType Custom { get; } = new RpInMageRecoveryPointType(CustomValue);
        /// <summary> Determines if two <see cref="RpInMageRecoveryPointType"/> values are the same. </summary>
        public static bool operator ==(RpInMageRecoveryPointType left, RpInMageRecoveryPointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RpInMageRecoveryPointType"/> values are not the same. </summary>
        public static bool operator !=(RpInMageRecoveryPointType left, RpInMageRecoveryPointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RpInMageRecoveryPointType"/>. </summary>
        public static implicit operator RpInMageRecoveryPointType(string value) => new RpInMageRecoveryPointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RpInMageRecoveryPointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RpInMageRecoveryPointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
