// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    [PersistableModelProxy(typeof(UnknownReplicationProviderSpecificContainerCreationContent))]
    public partial class ReplicationProviderSpecificContainerCreationContent : IUtf8JsonSerializable, IJsonModel<ReplicationProviderSpecificContainerCreationContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ReplicationProviderSpecificContainerCreationContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ReplicationProviderSpecificContainerCreationContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReplicationProviderSpecificContainerCreationContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ReplicationProviderSpecificContainerCreationContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("instanceType"u8);
            writer.WriteStringValue(InstanceType);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ReplicationProviderSpecificContainerCreationContent IJsonModel<ReplicationProviderSpecificContainerCreationContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReplicationProviderSpecificContainerCreationContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ReplicationProviderSpecificContainerCreationContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeReplicationProviderSpecificContainerCreationContent(document.RootElement, options);
        }

        internal static ReplicationProviderSpecificContainerCreationContent DeserializeReplicationProviderSpecificContainerCreationContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("instanceType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "A2A": return A2AContainerCreationContent.DeserializeA2AContainerCreationContent(element, options);
                    case "A2ACrossClusterMigration": return A2ACrossClusterMigrationContainerCreationContent.DeserializeA2ACrossClusterMigrationContainerCreationContent(element, options);
                    case "VMwareCbt": return VMwareCbtContainerCreationContent.DeserializeVMwareCbtContainerCreationContent(element, options);
                }
            }
            return UnknownReplicationProviderSpecificContainerCreationContent.DeserializeUnknownReplicationProviderSpecificContainerCreationContent(element, options);
        }

        BinaryData IPersistableModel<ReplicationProviderSpecificContainerCreationContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReplicationProviderSpecificContainerCreationContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ReplicationProviderSpecificContainerCreationContent)} does not support writing '{options.Format}' format.");
            }
        }

        ReplicationProviderSpecificContainerCreationContent IPersistableModel<ReplicationProviderSpecificContainerCreationContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReplicationProviderSpecificContainerCreationContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeReplicationProviderSpecificContainerCreationContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ReplicationProviderSpecificContainerCreationContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ReplicationProviderSpecificContainerCreationContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
