// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The ReplicationProtectedItemOperation. </summary>
    public readonly partial struct ReplicationProtectedItemOperation : IEquatable<ReplicationProtectedItemOperation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReplicationProtectedItemOperation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReplicationProtectedItemOperation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReverseReplicateValue = "ReverseReplicate";
        private const string CommitValue = "Commit";
        private const string PlannedFailoverValue = "PlannedFailover";
        private const string UnplannedFailoverValue = "UnplannedFailover";
        private const string DisableProtectionValue = "DisableProtection";
        private const string TestFailoverValue = "TestFailover";
        private const string TestFailoverCleanupValue = "TestFailoverCleanup";
        private const string FailbackValue = "Failback";
        private const string FinalizeFailbackValue = "FinalizeFailback";
        private const string CancelFailoverValue = "CancelFailover";
        private const string ChangePitValue = "ChangePit";
        private const string RepairReplicationValue = "RepairReplication";
        private const string SwitchProtectionValue = "SwitchProtection";
        private const string CompleteMigrationValue = "CompleteMigration";

        /// <summary> ReverseReplicate. </summary>
        public static ReplicationProtectedItemOperation ReverseReplicate { get; } = new ReplicationProtectedItemOperation(ReverseReplicateValue);
        /// <summary> Commit. </summary>
        public static ReplicationProtectedItemOperation Commit { get; } = new ReplicationProtectedItemOperation(CommitValue);
        /// <summary> PlannedFailover. </summary>
        public static ReplicationProtectedItemOperation PlannedFailover { get; } = new ReplicationProtectedItemOperation(PlannedFailoverValue);
        /// <summary> UnplannedFailover. </summary>
        public static ReplicationProtectedItemOperation UnplannedFailover { get; } = new ReplicationProtectedItemOperation(UnplannedFailoverValue);
        /// <summary> DisableProtection. </summary>
        public static ReplicationProtectedItemOperation DisableProtection { get; } = new ReplicationProtectedItemOperation(DisableProtectionValue);
        /// <summary> TestFailover. </summary>
        public static ReplicationProtectedItemOperation TestFailover { get; } = new ReplicationProtectedItemOperation(TestFailoverValue);
        /// <summary> TestFailoverCleanup. </summary>
        public static ReplicationProtectedItemOperation TestFailoverCleanup { get; } = new ReplicationProtectedItemOperation(TestFailoverCleanupValue);
        /// <summary> Failback. </summary>
        public static ReplicationProtectedItemOperation Failback { get; } = new ReplicationProtectedItemOperation(FailbackValue);
        /// <summary> FinalizeFailback. </summary>
        public static ReplicationProtectedItemOperation FinalizeFailback { get; } = new ReplicationProtectedItemOperation(FinalizeFailbackValue);
        /// <summary> CancelFailover. </summary>
        public static ReplicationProtectedItemOperation CancelFailover { get; } = new ReplicationProtectedItemOperation(CancelFailoverValue);
        /// <summary> ChangePit. </summary>
        public static ReplicationProtectedItemOperation ChangePit { get; } = new ReplicationProtectedItemOperation(ChangePitValue);
        /// <summary> RepairReplication. </summary>
        public static ReplicationProtectedItemOperation RepairReplication { get; } = new ReplicationProtectedItemOperation(RepairReplicationValue);
        /// <summary> SwitchProtection. </summary>
        public static ReplicationProtectedItemOperation SwitchProtection { get; } = new ReplicationProtectedItemOperation(SwitchProtectionValue);
        /// <summary> CompleteMigration. </summary>
        public static ReplicationProtectedItemOperation CompleteMigration { get; } = new ReplicationProtectedItemOperation(CompleteMigrationValue);
        /// <summary> Determines if two <see cref="ReplicationProtectedItemOperation"/> values are the same. </summary>
        public static bool operator ==(ReplicationProtectedItemOperation left, ReplicationProtectedItemOperation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReplicationProtectedItemOperation"/> values are not the same. </summary>
        public static bool operator !=(ReplicationProtectedItemOperation left, ReplicationProtectedItemOperation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReplicationProtectedItemOperation"/>. </summary>
        public static implicit operator ReplicationProtectedItemOperation(string value) => new ReplicationProtectedItemOperation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReplicationProtectedItemOperation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReplicationProtectedItemOperation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
