// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Properties model for replication eligibility results API. </summary>
    public partial class ReplicationEligibilityResultProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReplicationEligibilityResultProperties"/>. </summary>
        internal ReplicationEligibilityResultProperties()
        {
            Errors = new ChangeTrackingList<ReplicationEligibilityResultErrorInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="ReplicationEligibilityResultProperties"/>. </summary>
        /// <param name="clientRequestId"> The client request Id. </param>
        /// <param name="errors"> The error details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReplicationEligibilityResultProperties(string clientRequestId, IReadOnlyList<ReplicationEligibilityResultErrorInfo> errors, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClientRequestId = clientRequestId;
            Errors = errors;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The client request Id. </summary>
        public string ClientRequestId { get; }
        /// <summary> The error details. </summary>
        public IReadOnlyList<ReplicationEligibilityResultErrorInfo> Errors { get; }
    }
}
