// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Unpairing input properties. </summary>
    internal partial class RemoveProtectionContainerMappingProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RemoveProtectionContainerMappingProperties"/>. </summary>
        public RemoveProtectionContainerMappingProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RemoveProtectionContainerMappingProperties"/>. </summary>
        /// <param name="providerSpecificContent"> Provider specific input for unpairing. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RemoveProtectionContainerMappingProperties(ReplicationProviderContainerUnmappingContent providerSpecificContent, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProviderSpecificContent = providerSpecificContent;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Provider specific input for unpairing. </summary>
        internal ReplicationProviderContainerUnmappingContent ProviderSpecificContent { get; set; }
        /// <summary> The class type. </summary>
        public string ProviderSpecificContentInstanceType
        {
            get => ProviderSpecificContent is null ? default : ProviderSpecificContent.InstanceType;
            set
            {
                if (ProviderSpecificContent is null)
                    ProviderSpecificContent = new ReplicationProviderContainerUnmappingContent();
                ProviderSpecificContent.InstanceType = value;
            }
        }
    }
}
