// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Container unpairing input. </summary>
    public partial class RemoveProtectionContainerMappingContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RemoveProtectionContainerMappingContent"/>. </summary>
        public RemoveProtectionContainerMappingContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RemoveProtectionContainerMappingContent"/>. </summary>
        /// <param name="properties"> Configure protection input properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RemoveProtectionContainerMappingContent(RemoveProtectionContainerMappingProperties properties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Configure protection input properties. </summary>
        internal RemoveProtectionContainerMappingProperties Properties { get; set; }
        /// <summary> The class type. </summary>
        public string ProviderSpecificContentInstanceType
        {
            get => Properties is null ? default : Properties.ProviderSpecificContentInstanceType;
            set
            {
                if (Properties is null)
                    Properties = new RemoveProtectionContainerMappingProperties();
                Properties.ProviderSpecificContentInstanceType = value;
            }
        }
    }
}
