// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> A value indicating whether the recovery point is multi VM consistent. </summary>
    public readonly partial struct RecoveryPointSyncType : IEquatable<RecoveryPointSyncType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecoveryPointSyncType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecoveryPointSyncType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MultiVmSyncRecoveryPointValue = "MultiVmSyncRecoveryPoint";
        private const string PerVmRecoveryPointValue = "PerVmRecoveryPoint";

        /// <summary> MultiVmSyncRecoveryPoint. </summary>
        public static RecoveryPointSyncType MultiVmSyncRecoveryPoint { get; } = new RecoveryPointSyncType(MultiVmSyncRecoveryPointValue);
        /// <summary> PerVmRecoveryPoint. </summary>
        public static RecoveryPointSyncType PerVmRecoveryPoint { get; } = new RecoveryPointSyncType(PerVmRecoveryPointValue);
        /// <summary> Determines if two <see cref="RecoveryPointSyncType"/> values are the same. </summary>
        public static bool operator ==(RecoveryPointSyncType left, RecoveryPointSyncType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecoveryPointSyncType"/> values are not the same. </summary>
        public static bool operator !=(RecoveryPointSyncType left, RecoveryPointSyncType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecoveryPointSyncType"/>. </summary>
        public static implicit operator RecoveryPointSyncType(string value) => new RecoveryPointSyncType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecoveryPointSyncType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecoveryPointSyncType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
