// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    [PersistableModelProxy(typeof(UnknownRecoveryPlanProviderSpecificFailoverContent))]
    public partial class RecoveryPlanProviderSpecificFailoverContent : IUtf8JsonSerializable, IJsonModel<RecoveryPlanProviderSpecificFailoverContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RecoveryPlanProviderSpecificFailoverContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RecoveryPlanProviderSpecificFailoverContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecoveryPlanProviderSpecificFailoverContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecoveryPlanProviderSpecificFailoverContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("instanceType"u8);
            writer.WriteStringValue(InstanceType);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RecoveryPlanProviderSpecificFailoverContent IJsonModel<RecoveryPlanProviderSpecificFailoverContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecoveryPlanProviderSpecificFailoverContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecoveryPlanProviderSpecificFailoverContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRecoveryPlanProviderSpecificFailoverContent(document.RootElement, options);
        }

        internal static RecoveryPlanProviderSpecificFailoverContent DeserializeRecoveryPlanProviderSpecificFailoverContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("instanceType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "A2A": return RecoveryPlanA2AFailoverContent.DeserializeRecoveryPlanA2AFailoverContent(element, options);
                    case "HyperVReplicaAzure": return RecoveryPlanHyperVReplicaAzureFailoverContent.DeserializeRecoveryPlanHyperVReplicaAzureFailoverContent(element, options);
                    case "HyperVReplicaAzureFailback": return RecoveryPlanHyperVReplicaAzureFailbackContent.DeserializeRecoveryPlanHyperVReplicaAzureFailbackContent(element, options);
                    case "InMage": return RecoveryPlanInMageFailoverContent.DeserializeRecoveryPlanInMageFailoverContent(element, options);
                    case "InMageAzureV2": return RecoveryPlanInMageAzureV2FailoverContent.DeserializeRecoveryPlanInMageAzureV2FailoverContent(element, options);
                    case "InMageRcm": return RecoveryPlanInMageRcmFailoverContent.DeserializeRecoveryPlanInMageRcmFailoverContent(element, options);
                    case "InMageRcmFailback": return RecoveryPlanInMageRcmFailbackFailoverContent.DeserializeRecoveryPlanInMageRcmFailbackFailoverContent(element, options);
                }
            }
            return UnknownRecoveryPlanProviderSpecificFailoverContent.DeserializeUnknownRecoveryPlanProviderSpecificFailoverContent(element, options);
        }

        BinaryData IPersistableModel<RecoveryPlanProviderSpecificFailoverContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecoveryPlanProviderSpecificFailoverContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RecoveryPlanProviderSpecificFailoverContent)} does not support writing '{options.Format}' format.");
            }
        }

        RecoveryPlanProviderSpecificFailoverContent IPersistableModel<RecoveryPlanProviderSpecificFailoverContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecoveryPlanProviderSpecificFailoverContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRecoveryPlanProviderSpecificFailoverContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RecoveryPlanProviderSpecificFailoverContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RecoveryPlanProviderSpecificFailoverContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
