// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The recovery point type. </summary>
    public readonly partial struct RecoveryPlanPointType : IEquatable<RecoveryPlanPointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecoveryPlanPointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecoveryPlanPointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LatestValue = "Latest";
        private const string LatestApplicationConsistentValue = "LatestApplicationConsistent";
        private const string LatestCrashConsistentValue = "LatestCrashConsistent";
        private const string LatestProcessedValue = "LatestProcessed";

        /// <summary> Latest. </summary>
        public static RecoveryPlanPointType Latest { get; } = new RecoveryPlanPointType(LatestValue);
        /// <summary> LatestApplicationConsistent. </summary>
        public static RecoveryPlanPointType LatestApplicationConsistent { get; } = new RecoveryPlanPointType(LatestApplicationConsistentValue);
        /// <summary> LatestCrashConsistent. </summary>
        public static RecoveryPlanPointType LatestCrashConsistent { get; } = new RecoveryPlanPointType(LatestCrashConsistentValue);
        /// <summary> LatestProcessed. </summary>
        public static RecoveryPlanPointType LatestProcessed { get; } = new RecoveryPlanPointType(LatestProcessedValue);
        /// <summary> Determines if two <see cref="RecoveryPlanPointType"/> values are the same. </summary>
        public static bool operator ==(RecoveryPlanPointType left, RecoveryPlanPointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecoveryPlanPointType"/> values are not the same. </summary>
        public static bool operator !=(RecoveryPlanPointType left, RecoveryPlanPointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecoveryPlanPointType"/>. </summary>
        public static implicit operator RecoveryPlanPointType(string value) => new RecoveryPlanPointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecoveryPlanPointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecoveryPlanPointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
