// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Recovery plan InMageRcmFailback failover input. </summary>
    public partial class RecoveryPlanInMageRcmFailbackFailoverContent : RecoveryPlanProviderSpecificFailoverContent
    {
        /// <summary> Initializes a new instance of <see cref="RecoveryPlanInMageRcmFailbackFailoverContent"/>. </summary>
        /// <param name="recoveryPointType"> The recovery point type. </param>
        public RecoveryPlanInMageRcmFailbackFailoverContent(InMageRcmFailbackRecoveryPointType recoveryPointType)
        {
            RecoveryPointType = recoveryPointType;
            InstanceType = "InMageRcmFailback";
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryPlanInMageRcmFailbackFailoverContent"/>. </summary>
        /// <param name="instanceType"> The class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="recoveryPointType"> The recovery point type. </param>
        /// <param name="useMultiVmSyncPoint"> A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover. </param>
        internal RecoveryPlanInMageRcmFailbackFailoverContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, InMageRcmFailbackRecoveryPointType recoveryPointType, string useMultiVmSyncPoint) : base(instanceType, serializedAdditionalRawData)
        {
            RecoveryPointType = recoveryPointType;
            UseMultiVmSyncPoint = useMultiVmSyncPoint;
            InstanceType = instanceType ?? "InMageRcmFailback";
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryPlanInMageRcmFailbackFailoverContent"/> for deserialization. </summary>
        internal RecoveryPlanInMageRcmFailbackFailoverContent()
        {
        }

        /// <summary> The recovery point type. </summary>
        public InMageRcmFailbackRecoveryPointType RecoveryPointType { get; }
        /// <summary> A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover. </summary>
        public string UseMultiVmSyncPoint { get; set; }
    }
}
